/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXB;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import ru.yandex.qatools.allure.commons.BadXmlCharacterFilterReader;
import ru.yandex.qatools.allure.config.AllureConfig;
import ru.yandex.qatools.allure.model.TestSuiteResult;

public final class AllureFileUtils {
    AllureFileUtils() {
        throw new IllegalStateException();
    }

    public static TestSuiteResult unmarshal(File testSuite) throws IOException {
        try (FileInputStream stream = new FileInputStream(testSuite);){
            TestSuiteResult testSuiteResult = AllureFileUtils.unmarshal(stream);
            return testSuiteResult;
        }
    }

    public static TestSuiteResult unmarshal(InputStream testSuite) {
        return AllureFileUtils.unmarshal(new InputStreamReader(testSuite, StandardCharsets.UTF_8));
    }

    public static TestSuiteResult unmarshal(Reader testSuite) {
        return (TestSuiteResult)JAXB.unmarshal((Reader)new BadXmlCharacterFilterReader(testSuite), TestSuiteResult.class);
    }

    public static List<TestSuiteResult> unmarshalSuites(File ... directories) throws IOException {
        ArrayList<TestSuiteResult> results = new ArrayList<TestSuiteResult>();
        List<File> files = AllureFileUtils.listTestSuiteFiles(directories);
        for (File file : files) {
            results.add(AllureFileUtils.unmarshal(file));
        }
        return results;
    }

    public static List<File> listTestSuiteFiles(File ... directories) {
        return AllureFileUtils.listFilesByRegex(AllureConfig.newInstance().getTestSuiteFileRegex(), directories);
    }

    public static List<File> listAttachmentFiles(File ... directories) {
        return AllureFileUtils.listFilesByRegex(AllureConfig.newInstance().getAttachmentFileRegex(), directories);
    }

    public static List<File> listFilesByRegex(String regex, File ... directories) {
        return AllureFileUtils.listFiles(directories, (IOFileFilter)new RegexFileFilter(regex), CanReadFileFilter.CAN_READ);
    }

    public static List<File> listFiles(File[] directories, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        ArrayList<File> files = new ArrayList<File>();
        for (File directory : directories) {
            if (!directory.isDirectory()) continue;
            Collection filesInDirectory = FileUtils.listFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
            files.addAll(filesInDirectory);
        }
        return files;
    }
}

