/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.experimental;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.allure.events.ClearStepStorageEvent;
import ru.yandex.qatools.allure.events.ClearTestStorageEvent;
import ru.yandex.qatools.allure.events.StepEvent;
import ru.yandex.qatools.allure.events.StepFinishedEvent;
import ru.yandex.qatools.allure.events.StepStartedEvent;
import ru.yandex.qatools.allure.events.TestCaseEvent;
import ru.yandex.qatools.allure.events.TestCaseFinishedEvent;
import ru.yandex.qatools.allure.events.TestCaseStartedEvent;
import ru.yandex.qatools.allure.events.TestSuiteEvent;
import ru.yandex.qatools.allure.events.TestSuiteFinishedEvent;
import ru.yandex.qatools.allure.experimental.LifecycleListener;

public class ListenersNotifier
extends LifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListenersNotifier.class);
    private List<LifecycleListener> listeners = new ArrayList<LifecycleListener>();

    public ListenersNotifier() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ListenersNotifier(ClassLoader classLoader) {
        this.loadListeners(ServiceLoader.load(LifecycleListener.class, classLoader));
    }

    private void loadListeners(ServiceLoader<LifecycleListener> loader) {
        Iterator<LifecycleListener> iterator = loader.iterator();
        while (this.hasNextSafely(iterator)) {
            try {
                LifecycleListener listener = iterator.next();
                this.listeners.add(listener);
                LOGGER.info(String.format("Found %s: %s", LifecycleListener.class, listener.getClass()));
            }
            catch (ServiceConfigurationError e) {
                LOGGER.error("iterator.next() failed", (Throwable)e);
            }
        }
    }

    private boolean hasNextSafely(Iterator iterator) {
        try {
            return iterator.hasNext();
        }
        catch (Exception e) {
            LOGGER.error("iterator.hasNext() failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public void fire(StepStartedEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    @Override
    public void fire(StepEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    @Override
    public void fire(StepFinishedEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    @Override
    public void fire(TestCaseStartedEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    @Override
    public void fire(TestCaseEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    @Override
    public void fire(TestCaseFinishedEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    @Override
    public void fire(TestSuiteEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    @Override
    public void fire(TestSuiteFinishedEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    @Override
    public void fire(ClearStepStorageEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    @Override
    public void fire(ClearTestStorageEvent event) {
        for (LifecycleListener listener : this.listeners) {
            try {
                listener.fire(event);
            }
            catch (Exception e) {
                this.logError(listener, e);
            }
        }
    }

    private void logError(LifecycleListener listener, Exception e) {
        LOGGER.error("Error for listener " + listener.getClass(), (Throwable)e);
    }

    public void addListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    public List<LifecycleListener> getListeners() {
        return this.listeners;
    }
}

