/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.allure.config.AllureConfig;
import ru.yandex.qatools.allure.config.AllureNamingUtils;
import ru.yandex.qatools.allure.exceptions.AllureException;
import ru.yandex.qatools.allure.model.Attachment;
import ru.yandex.qatools.allure.model.ObjectFactory;
import ru.yandex.qatools.allure.model.TestSuiteResult;
import ru.yandex.qatools.allure.utils.BadXmlCharacterFilterWriter;

public final class AllureResultsUtils {
    private static File resultsDirectory;
    private static final Object RESULT_DIRECTORY_LOCK;
    private static final Object ATTACHMENTS_LOCK;
    private static final AllureConfig CONFIG;
    private static final Logger LOGGER;

    AllureResultsUtils() {
        throw new IllegalStateException("Don't instance AllureResultsUtils");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getResultsDirectory() {
        Object object = RESULT_DIRECTORY_LOCK;
        synchronized (object) {
            if (resultsDirectory == null) {
                resultsDirectory = AllureResultsUtils.createResultsDirectory();
            }
        }
        return resultsDirectory;
    }

    private static File createResultsDirectory() {
        File resultsDirectory = CONFIG.getResultsDirectory();
        if (AllureResultsUtils.createDirectories(resultsDirectory)) {
            return resultsDirectory;
        }
        LOGGER.error(String.format("Results directory <%s> doesn't exists and can't be created, using default directory", resultsDirectory.getAbsolutePath()));
        resultsDirectory = AllureConfig.getDefaultResultsDirectory();
        if (AllureResultsUtils.createDirectories(resultsDirectory)) {
            return resultsDirectory;
        }
        LOGGER.error(String.format("Default results directory <%s> doesn't exists and can't be created, using temp directory", resultsDirectory.getAbsolutePath()));
        try {
            return Files.createTempDirectory("allure-results", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new AllureException("Can't create results directory", e);
        }
    }

    public static boolean createDirectories(File dir) {
        return dir.exists() || dir.mkdirs();
    }

    public static void setResultsDirectory(File resultsDirectory) {
        AllureResultsUtils.resultsDirectory = resultsDirectory;
    }

    public static void writeTestSuiteResult(TestSuiteResult testSuite) {
        AllureResultsUtils.writeTestSuiteResult(testSuite, new File(AllureResultsUtils.getResultsDirectory(), AllureNamingUtils.generateTestSuiteFileName()));
    }

    public static void writeTestSuiteResult(TestSuiteResult testSuite, File testSuiteResultFile) {
        try {
            AllureResultsUtils.marshaller(TestSuiteResult.class).marshal((Object)new ObjectFactory().createTestSuite(testSuite), (Writer)new BadXmlCharacterFilterWriter(testSuiteResultFile));
        }
        catch (Exception e) {
            LOGGER.error("Error while marshaling testSuite", (Throwable)e);
        }
    }

    public static Marshaller marshaller(Class<?> clazz) {
        Marshaller m = AllureResultsUtils.createMarshallerForClass(clazz);
        AllureResultsUtils.setPropertySafely(m, "jaxb.formatted.output", true);
        AllureResultsUtils.setPropertySafely(m, "jaxb.encoding", StandardCharsets.UTF_8.toString());
        return m;
    }

    public static Marshaller createMarshallerForClass(Class<?> clazz) {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{clazz}).createMarshaller();
        }
        catch (JAXBException e) {
            throw new AllureException("Can't create marshaller for class " + clazz, e);
        }
    }

    public static void setPropertySafely(Marshaller marshaller, String name, Object value) {
        try {
            marshaller.setProperty(name, value);
        }
        catch (PropertyException e) {
            LOGGER.warn(String.format("Can't set \"%s\" property to given marshaller", name), (Throwable)e);
        }
    }

    public static boolean deleteAttachment(Attachment attachment) {
        File attachmentFile = new File(AllureResultsUtils.getResultsDirectory(), attachment.getSource());
        return attachmentFile.exists() && attachmentFile.canWrite() && attachmentFile.delete();
    }

    public static Attachment writeAttachmentSafely(byte[] attachment, String title, String type) {
        try {
            return type == null || type.isEmpty() ? AllureResultsUtils.writeAttachment(attachment, title) : AllureResultsUtils.writeAttachment(attachment, title, type);
        }
        catch (Exception e) {
            LOGGER.trace("Error while saving attachment " + title + ":" + type, (Throwable)e);
            return AllureResultsUtils.writeAttachmentWithErrorMessage(e, title);
        }
    }

    public static Attachment writeAttachmentWithErrorMessage(Throwable throwable, String title) {
        String message = throwable.getMessage();
        try {
            return AllureResultsUtils.writeAttachment(message.getBytes(CONFIG.getAttachmentsEncoding()), title);
        }
        catch (Exception e) {
            e.addSuppressed(throwable);
            LOGGER.error(String.format("Can't write attachment \"%s\"", title), (Throwable)e);
            return new Attachment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attachment writeAttachment(byte[] attachment, String title, String type) throws IOException {
        String name = AllureResultsUtils.generateAttachmentName();
        String extension = AllureResultsUtils.getExtensionByMimeType(type);
        String source = name + extension;
        File file = new File(AllureResultsUtils.getResultsDirectory(), source);
        Object object = ATTACHMENTS_LOCK;
        synchronized (object) {
            if (!file.exists()) {
                try (FileOutputStream fos = new FileOutputStream(file);){
                    fos.write(attachment);
                }
            }
        }
        return new Attachment().withTitle(title).withSource(source).withType(type);
    }

    public static Attachment writeAttachment(byte[] attachment, String title) throws IOException {
        String type = MimeTypes.getDefaultMimeTypes().detect((InputStream)new ByteArrayInputStream(attachment), new Metadata()).toString();
        return AllureResultsUtils.writeAttachment(attachment, title, type);
    }

    public static String generateAttachmentName() {
        return UUID.randomUUID().toString() + CONFIG.getAttachmentFileSuffix();
    }

    public static String getExtensionByMimeType(String type) {
        MimeTypes types = MimeTypes.getDefaultMimeTypes();
        try {
            return types.forName(type).getExtension();
        }
        catch (Exception e) {
            LOGGER.warn("Can't detect extension for MIME-type " + type, (Throwable)e);
            return "";
        }
    }

    static {
        RESULT_DIRECTORY_LOCK = new Object();
        ATTACHMENTS_LOCK = new Object();
        CONFIG = AllureConfig.newInstance();
        LOGGER = LoggerFactory.getLogger(AllureResultsUtils.class);
    }
}

