/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.config;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;

@Resource.Classpath(value="allure.properties")
public class AllureConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AllureConfig.class);
    protected static final File DEFAULT_RESULTS_DIRECTORY = new File("target/allure-results");
    public static final int DEFAULT_MAX_TITLE_LENGTH = 120;
    @Property(value="allure.model.schema.file.name")
    protected String schemaFileName = "allure.xsd";
    @Property(value="allure.report.remove.attachments")
    protected String removeAttachments = "a^";
    @Property(value="allure.results.testsuite.file.regex")
    protected String testSuiteFileRegex = ".*-testsuite\\.xml";
    @Property(value="allure.results.testsuite.file.suffix")
    protected String testSuiteFileSuffix = "testsuite";
    @Property(value="allure.results.testsuite.file.extension")
    protected String testSuiteFileExtension = "xml";
    @Property(value="allure.results.attachment.file.regex")
    protected String attachmentFileRegex = ".+-attachment(\\..+)?";
    @Property(value="allure.results.attachment.file.suffix")
    protected String attachmentFileSuffix = "-attachment";
    @Property(value="allure.results.environment.xml.file.name")
    protected String environmentXmlFileRegex = ".*environment\\.xml";
    @Property(value="allure.results.environment.properties.file.name")
    protected String environmentPropertiesFileRegex = ".*environment\\.properties";
    @Property(value="allure.results.directory")
    protected File resultsDirectory = DEFAULT_RESULTS_DIRECTORY;
    @Property(value="allure.attachments.encoding")
    protected Charset attachmentsEncoding = StandardCharsets.UTF_8;
    @Property(value="allure.max.title.length")
    protected int maxTitleLength = 120;
    @Property(value="allure.issues.tracker.pattern")
    protected String issueTrackerPattern = "%s";
    @Property(value="allure.tests.management.pattern")
    protected String tmsPattern = "%s";
    protected String version = this.getClass().getPackage().getImplementationVersion();

    public AllureConfig() {
        PropertyLoader.populate((Object)this);
    }

    public static AllureConfig newInstance() {
        return new AllureConfig();
    }

    public String getSchemaFileName() {
        return this.schemaFileName;
    }

    public String getRemoveAttachments() {
        return this.removeAttachments;
    }

    public String getTestSuiteFileRegex() {
        return this.testSuiteFileRegex;
    }

    public String getTestSuiteFileSuffix() {
        return this.testSuiteFileSuffix;
    }

    public String getTestSuiteFileExtension() {
        return this.testSuiteFileExtension;
    }

    public String getAttachmentFileRegex() {
        return this.attachmentFileRegex;
    }

    public String getAttachmentFileSuffix() {
        return this.attachmentFileSuffix;
    }

    public String getEnvironmentXmlFileRegex() {
        return this.environmentXmlFileRegex;
    }

    public String getEnvironmentPropertiesFileRegex() {
        return this.environmentPropertiesFileRegex;
    }

    public File getResultsDirectory() {
        return this.resultsDirectory;
    }

    public Charset getAttachmentsEncoding() {
        return this.attachmentsEncoding;
    }

    public int getMaxTitleLength() {
        return this.maxTitleLength;
    }

    public String getIssueTrackerPattern() {
        return this.issueTrackerPattern;
    }

    public String getTmsPattern() {
        return this.tmsPattern;
    }

    public String getVersion() {
        return this.version;
    }

    public void setResultsDirectory(File resultsDirectory) {
        this.resultsDirectory = resultsDirectory;
    }

    public static File getDefaultResultsDirectory() {
        return DEFAULT_RESULTS_DIRECTORY;
    }
}

