/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.config;

import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;
import ru.yandex.qatools.allure.config.AllureConfig;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.LabelName;
import ru.yandex.qatools.allure.model.SeverityLevel;

public final class AllureModelUtils {
    AllureModelUtils() {
        throw new IllegalStateException("Don't instance AllureModelUtils");
    }

    public static Validator getAllureSchemaValidator() throws SAXException {
        String schemaFileName = AllureConfig.newInstance().getSchemaFileName();
        InputStream schemaFile = ClassLoader.getSystemResourceAsStream(schemaFileName);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(schemaFile));
        return schema.newValidator();
    }

    public static Label createFeatureLabel(String feature) {
        return AllureModelUtils.createLabel(LabelName.FEATURE, feature);
    }

    public static Label createStoryLabel(String story) {
        return AllureModelUtils.createLabel(LabelName.STORY, story);
    }

    public static Label createSeverityLabel(SeverityLevel level) {
        return AllureModelUtils.createLabel(LabelName.SEVERITY, level.value());
    }

    public static Label createProgrammingLanguageLabel() {
        return AllureModelUtils.createLabel(LabelName.LANGUAGE, "JAVA");
    }

    public static Label createTestFrameworkLabel(String testFrameworkName) {
        return AllureModelUtils.createLabel(LabelName.FRAMEWORK, testFrameworkName);
    }

    public static Label createIssueLabel(String issueKey) {
        return AllureModelUtils.createLabel(LabelName.ISSUE, issueKey);
    }

    public static Label createTestLabel(String testKey) {
        return AllureModelUtils.createLabel(LabelName.TEST_ID, testKey);
    }

    public static Label createHostLabel(String host) {
        return AllureModelUtils.createLabel(LabelName.HOST, host);
    }

    public static Label createThreadLabel(String thread) {
        return AllureModelUtils.createLabel(LabelName.THREAD, thread);
    }

    public static Label createLabel(LabelName name, String value) {
        return new Label().withName(name.value()).withValue(value);
    }
}

