/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.config;

import java.util.UUID;
import ru.yandex.qatools.allure.config.AllureConfig;

public final class AllureNamingUtils {
    public static final String FILE_NAME_PATTERN = "%s-%s.%s";

    AllureNamingUtils() {
        throw new IllegalStateException("Don't instance AllureNamingUtils");
    }

    public static String generateTestSuiteFileName(String name) {
        AllureConfig config = AllureConfig.newInstance();
        return String.format(FILE_NAME_PATTERN, name, config.getTestSuiteFileSuffix(), config.getTestSuiteFileExtension());
    }

    public static String generateTestSuiteFileName() {
        return AllureNamingUtils.generateTestSuiteFileName(UUID.randomUUID().toString());
    }

    public static boolean isBadXmlCharacter(char c) {
        boolean cDataCharacter = c < ' ' && c != '\t' && c != '\r' && c != '\n';
        cDataCharacter |= c >= '\ud800' && c < '\ue000';
        return cDataCharacter |= c == '\ufffe' || c == '\uffff';
    }

    public static void replaceBadXmlCharactersBySpace(char[] cbuf, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            if (!AllureNamingUtils.isBadXmlCharacter(cbuf[i])) continue;
            cbuf[i] = 32;
        }
    }
}

