/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import java.io.File;
import ru.yandex.qatools.allure.data.AllureGuiceModule;
import ru.yandex.qatools.allure.data.AllureTestCase;
import ru.yandex.qatools.allure.data.AttachmentInfo;
import ru.yandex.qatools.allure.data.ReportGenerationException;
import ru.yandex.qatools.allure.data.converters.TestCaseConverter;
import ru.yandex.qatools.allure.data.io.Reader;
import ru.yandex.qatools.allure.data.io.ReportWriter;
import ru.yandex.qatools.allure.data.plugins.PluginManager;
import ru.yandex.qatools.allure.model.TestCaseResult;
import ru.yandex.qatools.commons.model.Environment;

public class AllureReportGenerator {
    @Inject
    private Reader<TestCaseResult> testCaseReader;
    @Inject
    private Reader<Environment> environmentReader;
    @Inject
    private Reader<AttachmentInfo> attachmentReader;
    @Inject
    private TestCaseConverter converter;
    @Inject
    private PluginManager pluginManager;

    public AllureReportGenerator(File ... inputDirectories) {
        this(AllureReportGenerator.class.getClassLoader(), inputDirectories);
    }

    public AllureReportGenerator(ClassLoader pluginClassLoader, File ... inputDirectories) {
        this(new AllureGuiceModule(pluginClassLoader, inputDirectories));
    }

    AllureReportGenerator(AbstractModule module) {
        Guice.createInjector((Module[])new Module[]{module}).injectMembers((Object)this);
    }

    public void generate(File outputDirectory) {
        ReportWriter writer = new ReportWriter(outputDirectory);
        this.generate(writer);
    }

    public void generate(ReportWriter writer) {
        if (!this.testCaseReader.iterator().hasNext()) {
            throw new ReportGenerationException("Could not find any allure results");
        }
        for (TestCaseResult result : this.testCaseReader) {
            this.pluginManager.prepare(result);
            AllureTestCase testCase = this.converter.convert(result);
            this.pluginManager.prepare(testCase);
            this.pluginManager.process(testCase);
            writer.write(testCase);
        }
        for (Environment environment : this.environmentReader) {
            this.pluginManager.prepare(environment);
            this.pluginManager.process(environment);
        }
        for (AttachmentInfo attachment : this.attachmentReader) {
            this.pluginManager.prepare(attachment);
            writer.write(attachment);
        }
        this.pluginManager.writePluginData(writer);
        this.pluginManager.writePluginResources(writer);
        this.pluginManager.writePluginList(writer);
        this.pluginManager.writePluginWidgets(writer);
        writer.writeReportInfo();
    }
}

