/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.inject.Inject;
import javax.xml.bind.JAXB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.allure.commons.AllureFileUtils;
import ru.yandex.qatools.allure.config.AllureConfig;
import ru.yandex.qatools.allure.data.io.Reader;
import ru.yandex.qatools.commons.model.Environment;
import ru.yandex.qatools.commons.model.Parameter;

public class EnvironmentReader
implements Reader<Environment> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentReader.class);
    private Iterator<File> xmlIterator;
    private Iterator<File> propertiesIterator;

    @Inject
    public EnvironmentReader(File ... inputDirectories) {
        AllureConfig config = AllureConfig.newInstance();
        this.xmlIterator = AllureFileUtils.listFilesByRegex((String)config.getEnvironmentXmlFileRegex(), (File[])inputDirectories).iterator();
        this.propertiesIterator = AllureFileUtils.listFilesByRegex((String)config.getEnvironmentPropertiesFileRegex(), (File[])inputDirectories).iterator();
    }

    public Iterator<Environment> iterator() {
        return new EnvironmentIterator();
    }

    public static Collection<Parameter> convertToParameters(Properties properties) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Object key : properties.keySet()) {
            Parameter parameter = new Parameter();
            parameter.setKey(key.toString());
            parameter.setName(key.toString());
            parameter.setValue(properties.getProperty(key.toString()));
            parameters.add(parameter);
        }
        return parameters;
    }

    private class EnvironmentIterator
    implements Iterator<Environment> {
        private EnvironmentIterator() {
        }

        @Override
        public boolean hasNext() {
            return EnvironmentReader.this.xmlIterator.hasNext() || EnvironmentReader.this.propertiesIterator.hasNext();
        }

        @Override
        public Environment next() {
            if (EnvironmentReader.this.propertiesIterator.hasNext()) {
                File file = (File)EnvironmentReader.this.propertiesIterator.next();
                Properties properties = new Properties();
                try {
                    Throwable throwable = null;
                    Object var4_12 = null;
                    try (FileInputStream fis = new FileInputStream(file);){
                        properties.load(fis);
                        Environment result = new Environment();
                        result.getParameter().addAll(EnvironmentReader.convertToParameters(properties));
                        return result;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Could not read environment .properties file " + file.getAbsolutePath(), (Throwable)e);
                    return this.next();
                }
            }
            if (EnvironmentReader.this.xmlIterator.hasNext()) {
                File file = (File)EnvironmentReader.this.xmlIterator.next();
                try {
                    Throwable properties = null;
                    Object var3_10 = null;
                    try (FileInputStream fis = new FileInputStream(file);){
                        return (Environment)JAXB.unmarshal((InputStream)fis, Environment.class);
                    }
                    catch (Throwable throwable) {
                        if (properties == null) {
                            properties = throwable;
                        } else if (properties != throwable) {
                            properties.addSuppressed(throwable);
                        }
                        throw properties;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Could not read environment .xml file " + file.getAbsolutePath(), (Throwable)e);
                    return this.next();
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

