/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data.io;

import com.google.inject.Inject;
import java.util.Iterator;
import ru.yandex.qatools.allure.data.io.Reader;
import ru.yandex.qatools.allure.data.utils.DescriptionUtils;
import ru.yandex.qatools.allure.model.Description;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.TestCaseResult;
import ru.yandex.qatools.allure.model.TestSuiteResult;

public class TestCaseReader
implements Reader<TestCaseResult> {
    public static final String SUITE_NAME = "suite-name";
    public static final String SUITE_TITLE = "suite-title";
    private Iterator<TestSuiteResult> testSuites;
    private Iterator<TestCaseResult> testCases;
    private TestSuiteResult currentSuite;

    @Inject
    public TestCaseReader(Reader<TestSuiteResult> suiteResultsReader) {
        this.testSuites = suiteResultsReader.iterator();
    }

    public Iterator<TestCaseResult> iterator() {
        return new TestCaseResultIterator();
    }

    private class TestCaseResultIterator
    implements Iterator<TestCaseResult> {
        private TestCaseResultIterator() {
        }

        private boolean nextSuite() {
            if ((TestCaseReader.this.testCases == null || !TestCaseReader.this.testCases.hasNext()) && TestCaseReader.this.testSuites.hasNext()) {
                TestCaseReader.this.currentSuite = (TestSuiteResult)TestCaseReader.this.testSuites.next();
                TestCaseReader.this.testCases = TestCaseReader.this.currentSuite.getTestCases().iterator();
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            return TestCaseReader.this.testCases != null && TestCaseReader.this.testCases.hasNext() || this.nextSuite() && this.hasNext();
        }

        @Override
        public TestCaseResult next() {
            if (!this.hasNext()) {
                return null;
            }
            TestCaseResult result = (TestCaseResult)TestCaseReader.this.testCases.next();
            result.getLabels().add(new Label().withName(TestCaseReader.SUITE_NAME).withValue(TestCaseReader.this.currentSuite.getName()));
            result.getLabels().add(new Label().withName(TestCaseReader.SUITE_TITLE).withValue(TestCaseReader.this.currentSuite.getTitle()));
            result.getLabels().addAll(TestCaseReader.this.currentSuite.getLabels());
            Description description = DescriptionUtils.mergeDescriptions(TestCaseReader.this.currentSuite, result);
            result.setDescription(description);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

