/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLoaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaderUtils.class);

    ServiceLoaderUtils() {
    }

    public static <T> List<T> load(ClassLoader classLoader, Class<T> serviceType) {
        ArrayList<T> foundServices = new ArrayList<T>();
        Iterator<T> iterator = ServiceLoader.load(serviceType, classLoader).iterator();
        while (ServiceLoaderUtils.checkHasNextSafely(iterator)) {
            try {
                T item = iterator.next();
                foundServices.add(item);
                LOGGER.info(String.format("Found %s [%s]", serviceType.getSimpleName(), item.toString()));
            }
            catch (ServiceConfigurationError e) {
                LOGGER.trace("Can't find services using Java SPI", (Throwable)e);
                LOGGER.error(e.getMessage());
            }
        }
        return foundServices;
    }

    public static boolean checkHasNextSafely(Iterator iterator) {
        try {
            return iterator.hasNext();
        }
        catch (Exception | ServiceConfigurationError e) {
            LOGGER.trace("Can't load some service using Java SPI", e);
            LOGGER.error(e.getMessage());
            return false;
        }
    }
}

