/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data.io;

import freemarker.template.Configuration;
import freemarker.template.Template;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.allure.data.AllureReportInfo;
import ru.yandex.qatools.allure.data.AllureTestCase;
import ru.yandex.qatools.allure.data.AttachmentInfo;
import ru.yandex.qatools.allure.data.ReportGenerationException;
import ru.yandex.qatools.allure.data.plugins.PluginData;
import ru.yandex.qatools.allure.data.utils.AllureReportUtils;
import ru.yandex.qatools.commons.model.Environment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportWriter
implements GroovyObject {
    public static final String DATA_DIRECTORY_NAME = "data";
    public static final String PLUGINS_DIRECTORY_NAME = "plugins";
    public static final String REPORT_JSON = "report.json";
    public static final String TESTCASE_SUFFIX = "-testcase.json";
    private final File outputDataDirectory;
    private final File outputPluginsDirectory;
    private final File indexHtml;
    private Long start;
    private Long size;
    private String name;
    private String id;
    private String url;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public ReportWriter(File file) {
        void outputDirectory;
        MetaClass metaClass;
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        int n = 0;
        this.size = (Long)ScriptBytecodeAdapter.castToType((Object)n, Long.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object object = callSiteArray[0].callStatic(AllureReportUtils.class, (Object)outputDirectory, (Object)DATA_DIRECTORY_NAME);
        this.outputDataDirectory = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
        Object object2 = callSiteArray[1].callStatic(AllureReportUtils.class, (Object)outputDirectory, (Object)PLUGINS_DIRECTORY_NAME);
        this.outputPluginsDirectory = (File)ScriptBytecodeAdapter.castToType((Object)object2, File.class);
        Object object3 = callSiteArray[2].callConstructor(File.class, (Object)outputDirectory, (Object)"index.html");
        this.indexHtml = (File)ScriptBytecodeAdapter.castToType((Object)object3, File.class);
        Object object4 = callSiteArray[3].call(System.class);
        this.start = (Long)ScriptBytecodeAdapter.castToType((Object)object4, Long.class);
    }

    public void write(Object object) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
            throw (Throwable)callSiteArray[4].callConstructor(ReportGenerationException.class, (Object)new GStringImpl(new Object[]{callSiteArray[5].call(object)}, new String[]{"Can't write object ", ""}));
        }
    }

    public void write(Collection items) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        callSiteArray[6].call((Object)items, (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _write_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _write_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _write_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _write_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "write";
                return new CallSiteArray(_write_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _write_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
    }

    public void write(AllureTestCase testCase) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        callSiteArray[7].call(Objects.class, (Object)testCase);
        callSiteArray[8].callCurrent((GroovyObject)this, callSiteArray[9].call(callSiteArray[10].callGetProperty((Object)testCase), (Object)TESTCASE_SUFFIX), (Object)testCase);
    }

    public void write(PluginData data) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        callSiteArray[11].call(Objects.class, (Object)data);
        if (callSiteArray[12].callGetProperty((Object)data) instanceof Environment) {
            Environment environment = (Environment)ScriptBytecodeAdapter.asType((Object)callSiteArray[13].callGetProperty((Object)data), Environment.class);
            Object object = callSiteArray[14].callGetProperty((Object)environment);
            this.name = ShortTypeHandling.castToString((Object)object);
            Object object2 = callSiteArray[15].callGetProperty((Object)environment);
            this.id = ShortTypeHandling.castToString((Object)object2);
            Object object3 = callSiteArray[16].callGetProperty((Object)environment);
            this.url = ShortTypeHandling.castToString((Object)object3);
        }
        callSiteArray[17].callCurrent((GroovyObject)this, callSiteArray[18].callGetProperty((Object)data), callSiteArray[19].callGetProperty((Object)data));
    }

    public void write(AttachmentInfo attachmentInfo) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        callSiteArray[20].call(Objects.class, (Object)attachmentInfo);
        try {
            Reference from = new Reference((Object)((Path)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call(Paths.class, callSiteArray[22].callGetProperty((Object)attachmentInfo)), Path.class)));
            callSiteArray[23].call(callSiteArray[24].callCurrent((GroovyObject)this, callSiteArray[25].callGetProperty((Object)attachmentInfo)), (Object)new GeneratedClosure(this, this, from){
                private /* synthetic */ Reference from;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _write_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.from = reference = from;
                }

                public Object doCall(Object output) {
                    CallSite[] callSiteArray = _write_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(Files.class, this.from.get(), output);
                }

                public Path getFrom() {
                    CallSite[] callSiteArray = _write_closure2.$getCallSiteArray();
                    return (Path)ScriptBytecodeAdapter.castToType((Object)this.from.get(), Path.class);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _write_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "copy";
                    return new CallSiteArray(_write_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _write_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
        }
        catch (IOException e) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call((Object)log)) ? callSiteArray[27].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[28].callGetProperty((Object)attachmentInfo), callSiteArray[29].callGetProperty((Object)attachmentInfo)}, new String[]{"Can't copy attachment ", " from ", ""}), (Object)e) : null;
        }
    }

    public void write(String pluginName, URL resource) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[30].callCurrent((GroovyObject)this, (Object)pluginName, (Object)resource);
        } else {
            this.copyResource(pluginName, resource);
        }
    }

    public void writeIndexHtml(List<String> plugins) {
        Reference plugins2 = new Reference(plugins);
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        Configuration cfg = (Configuration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callConstructor(Configuration.class, callSiteArray[32].callGetProperty(Configuration.class)), Configuration.class);
        callSiteArray[33].call((Object)cfg, callSiteArray[34].callGetProperty(callSiteArray[35].callCurrent((GroovyObject)this)), (Object)"");
        try {
            Reference template = new Reference((Object)((Template)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].call((Object)cfg, (Object)"index.html.ftl"), Template.class)));
            callSiteArray[37].call(callSiteArray[38].callConstructor(FileWriter.class, (Object)this.indexHtml), (Object)new GeneratedClosure(this, this, template, plugins2){
                private /* synthetic */ Reference template;
                private /* synthetic */ Reference plugins;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    Reference reference2;
                    CallSite[] callSiteArray = _writeIndexHtml_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.template = reference2 = template;
                    this.plugins = reference = plugins;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _writeIndexHtml_closure3.$getCallSiteArray();
                    return callSiteArray[0].call(this.template.get(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{ReportWriter.PLUGINS_DIRECTORY_NAME, this.plugins.get(), "version", "unknown"}), it);
                }

                public Template getTemplate() {
                    CallSite[] callSiteArray = _writeIndexHtml_closure3.$getCallSiteArray();
                    return (Template)ScriptBytecodeAdapter.castToType((Object)this.template.get(), Template.class);
                }

                public List getPlugins() {
                    CallSite[] callSiteArray = _writeIndexHtml_closure3.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.plugins.get(), List.class);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _writeIndexHtml_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _writeIndexHtml_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "process";
                    return new CallSiteArray(_writeIndexHtml_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _writeIndexHtml_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
        }
        catch (IOException e) {
            throw (Throwable)callSiteArray[39].callConstructor(ReportGenerationException.class, (Object)e);
        }
    }

    public void writeReportInfo() {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        Object stop = callSiteArray[40].call(System.class);
        Object info = callSiteArray[41].callConstructor(AllureReportInfo.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.id, "name", this.name, "url", this.url, "time", callSiteArray[42].call(stop, (Object)this.start), "size", this.size}));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[43].callStatic(AllureReportUtils.class, callSiteArray[44].callCurrent((GroovyObject)this, (Object)REPORT_JSON), info);
        } else {
            callSiteArray[45].callStatic(AllureReportUtils.class, (Object)this.getStreamToDataDirectory(REPORT_JSON), info);
        }
    }

    private void copyResource(String pluginName, URL resource) {
        Reference resource2 = new Reference((Object)resource);
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        Object resourceName = callSiteArray[46].call(FilenameUtils.class, callSiteArray[47].call((Object)((URL)resource2.get())));
        callSiteArray[48].call(callSiteArray[49].callCurrent((GroovyObject)this, (Object)pluginName, resourceName), (Object)new GeneratedClosure(this, this, resource2){
            private /* synthetic */ Reference resource;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _copyResource_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.resource = reference = resource;
            }

            public Object doCall(Object output) {
                Reference output2 = new Reference(output);
                CallSite[] callSiteArray = _copyResource_closure4.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(this.resource.get()), (Object)new GeneratedClosure((Object)this, this.getThisObject(), output2){
                    private /* synthetic */ Reference output;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.output = reference = output;
                    }

                    public Object doCall(Object input) {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return callSiteArray[0].call(this.output.get(), input);
                    }

                    public Object getOutput() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.output.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "leftShift";
                        return new CallSiteArray(_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                });
            }

            public URL getResource() {
                CallSite[] callSiteArray = _copyResource_closure4.$getCallSiteArray();
                return (URL)ScriptBytecodeAdapter.castToType((Object)this.resource.get(), URL.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _copyResource_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "withCloseable";
                stringArray[1] = "openStream";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _copyResource_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_copyResource_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _copyResource_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
    }

    private void serializeToData(String fileName, Object object) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        this.size = __$stMC || BytecodeInterface8.disabledStandardMetaClass() ? (Long)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].call((Object)this.size, callSiteArray[51].callStatic(AllureReportUtils.class, callSiteArray[52].callCurrent((GroovyObject)this, (Object)fileName), object)), Long.class) : (Long)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call((Object)this.size, callSiteArray[54].callStatic(AllureReportUtils.class, (Object)this.getStreamToDataDirectory(fileName), object)), Long.class);
    }

    private OutputStream getStreamToDataDirectory(String fileName) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        return (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callStatic(ReportWriter.class, (Object)this.outputDataDirectory, (Object)fileName), OutputStream.class);
    }

    private OutputStream getStreamToPluginDirectory(String pluginName, String fileName) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        Object pluginDir = callSiteArray[56].callStatic(AllureReportUtils.class, (Object)this.outputPluginsDirectory, (Object)pluginName);
        return (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callStatic(ReportWriter.class, pluginDir, (Object)fileName), OutputStream.class);
    }

    private static OutputStream getStream(File directory, String fileName) {
        CallSite[] callSiteArray = ReportWriter.$getCallSiteArray();
        OutputStream outputStream = (OutputStream)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callConstructor(FileOutputStream.class, callSiteArray[59].callConstructor(File.class, (Object)directory, (Object)fileName)), OutputStream.class);
        try {
            return outputStream;
        }
        catch (Exception e) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call((Object)log)) ? callSiteArray[61].call((Object)log, (Object)new GStringImpl(new Object[]{fileName}, new String[]{"Can't create directory ", " in data folder"}), (Object)e) : null;
            throw (Throwable)callSiteArray[62].callConstructor(ReportGenerationException.class, (Object)e);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ReportWriter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ReportWriter.$getCallSiteArray()[63].call(LoggerFactory.class, (Object)"ru.yandex.qatools.allure.data.io.ReportWriter");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "createDirectory";
        stringArray[1] = "createDirectory";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "currentTimeMillis";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "toString";
        stringArray[6] = "each";
        stringArray[7] = "requireNonNull";
        stringArray[8] = "serializeToData";
        stringArray[9] = "plus";
        stringArray[10] = "uid";
        stringArray[11] = "requireNonNull";
        stringArray[12] = DATA_DIRECTORY_NAME;
        stringArray[13] = DATA_DIRECTORY_NAME;
        stringArray[14] = "name";
        stringArray[15] = "id";
        stringArray[16] = "url";
        stringArray[17] = "serializeToData";
        stringArray[18] = "name";
        stringArray[19] = DATA_DIRECTORY_NAME;
        stringArray[20] = "requireNonNull";
        stringArray[21] = "get";
        stringArray[22] = "path";
        stringArray[23] = "withCloseable";
        stringArray[24] = "getStreamToDataDirectory";
        stringArray[25] = "source";
        stringArray[26] = "isErrorEnabled";
        stringArray[27] = "error";
        stringArray[28] = "source";
        stringArray[29] = "path";
        stringArray[30] = "copyResource";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "VERSION_2_3_23";
        stringArray[33] = "setClassLoaderForTemplateLoading";
        stringArray[34] = "classLoader";
        stringArray[35] = "getClass";
        stringArray[36] = "getTemplate";
        stringArray[37] = "withCloseable";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "currentTimeMillis";
        stringArray[41] = "<$constructor$>";
        stringArray[42] = "minus";
        stringArray[43] = "serialize";
        stringArray[44] = "getStreamToDataDirectory";
        stringArray[45] = "serialize";
        stringArray[46] = "getName";
        stringArray[47] = "toString";
        stringArray[48] = "withCloseable";
        stringArray[49] = "getStreamToPluginDirectory";
        stringArray[50] = "plus";
        stringArray[51] = "serialize";
        stringArray[52] = "getStreamToDataDirectory";
        stringArray[53] = "plus";
        stringArray[54] = "serialize";
        stringArray[55] = "getStream";
        stringArray[56] = "createDirectory";
        stringArray[57] = "getStream";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "isErrorEnabled";
        stringArray[61] = "error";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[64];
        ReportWriter.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ReportWriter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ReportWriter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

