/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data.io;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.allure.commons.AllureFileUtils;
import ru.yandex.qatools.allure.data.io.Reader;
import ru.yandex.qatools.allure.model.TestSuiteResult;

public class TestSuiteReader
implements Reader<TestSuiteResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSuiteReader.class);
    private final Iterator<File> testSuiteResultFiles;

    @Inject
    public TestSuiteReader(File ... resultDirectories) {
        this.testSuiteResultFiles = AllureFileUtils.listTestSuiteFiles((File[])resultDirectories).iterator();
    }

    public Iterator<TestSuiteResult> iterator() {
        return new TestSuiteResultIterator();
    }

    private class TestSuiteResultIterator
    implements Iterator<TestSuiteResult> {
        private TestSuiteResultIterator() {
        }

        @Override
        public boolean hasNext() {
            return TestSuiteReader.this.testSuiteResultFiles.hasNext();
        }

        @Override
        public TestSuiteResult next() {
            if (!this.hasNext()) {
                return null;
            }
            File next = (File)TestSuiteReader.this.testSuiteResultFiles.next();
            try {
                return AllureFileUtils.unmarshal((File)next);
            }
            catch (IOException e) {
                LOGGER.warn(String.format("Could not read <%s> file", next.getAbsoluteFile()), (Throwable)e);
                return this.next();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

