/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data.utils;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import ru.yandex.qatools.allure.data.ReportGenerationException;

public final class AllureReportUtils {
    AllureReportUtils() {
    }

    public static File createDirectory(File parent, String name) {
        File created = new File(parent, name);
        AllureReportUtils.checkDirectory(created);
        return created;
    }

    public static void checkDirectory(File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new ReportGenerationException(String.format("Can't create data directory <%s>", directory.getAbsolutePath()));
        }
    }

    public static int serialize(File directory, String name, Object obj) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream stream = new FileOutputStream(new File(directory, name));){
                return AllureReportUtils.serialize(stream, obj);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ReportGenerationException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int serialize(OutputStream stream, Object obj) {
        ObjectMapper mapper = AllureReportUtils.createMapperWithJaxbAnnotationInspector();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                DataOutputStream data = new DataOutputStream(stream);
                try {
                    int n;
                    block16: {
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)data, StandardCharsets.UTF_8);
                        try {
                            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)writer, obj);
                            n = data.size();
                            return n;
                        }
                        finally {
                            if (writer == null) break block16;
                            writer.close();
                        }
                    }
                    if (data != null) {
                        data.close();
                    }
                    return n;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (data == null) throw throwable;
                    data.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ReportGenerationException(e);
        }
    }

    public static ObjectMapper createMapperWithJaxbAnnotationInspector() {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationIntrospector annotationInspector = new JaxbAnnotationIntrospector(TypeFactory.defaultInstance());
        mapper.getSerializationConfig().with((AnnotationIntrospector)annotationInspector);
        return mapper;
    }
}

