/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data.utils;

import org.jvnet.jaxb2_commons.lang.StringUtils;
import ru.yandex.qatools.allure.model.Description;
import ru.yandex.qatools.allure.model.DescriptionType;
import ru.yandex.qatools.allure.model.TestCaseResult;
import ru.yandex.qatools.allure.model.TestSuiteResult;

public final class DescriptionUtils {
    DescriptionUtils() {
    }

    public static Description mergeDescriptions(TestSuiteResult testSuiteResult, TestCaseResult testCaseResult) {
        return DescriptionUtils.mergeDescriptions(testSuiteResult.getDescription(), testCaseResult.getDescription());
    }

    public static Description mergeDescriptions(Description testSuiteDescription, Description testCaseDescription) {
        if (testSuiteDescription == null) {
            return testCaseDescription;
        }
        if (testCaseDescription == null) {
            return testSuiteDescription;
        }
        Description description = new Description();
        if (!StringUtils.isEmpty((String)testSuiteDescription.getValue())) {
            DescriptionType descriptionType = DescriptionUtils.getDescriptionType(testSuiteDescription.getType(), testCaseDescription.getType());
            String descriptionValue = String.format("%s%s%s", testSuiteDescription.getValue(), DescriptionUtils.getSeparator(descriptionType), testCaseDescription.getValue());
            description.setValue(descriptionValue);
            description.setType(descriptionType);
        }
        return description;
    }

    private static String getSeparator(DescriptionType descriptionType) {
        return descriptionType.equals((Object)DescriptionType.MARKDOWN) ? String.valueOf(System.lineSeparator()) + System.lineSeparator() : System.lineSeparator();
    }

    private static DescriptionType getDescriptionType(DescriptionType suiteType, DescriptionType testCaseType) {
        return suiteType.equals((Object)DescriptionType.MARKDOWN) ? DescriptionType.MARKDOWN : testCaseType;
    }
}

