/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data.utils;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pegdown.PegDownProcessor;
import ru.yandex.qatools.allure.config.AllureConfig;

public final class TextUtils {
    private static final Integer RADIX = 16;
    public static final int UID_RANDOM_BYTES_COUNT = 8;

    private TextUtils() {
    }

    public static String generateUid() {
        SecureRandom rand = new SecureRandom();
        byte[] randomBytes = new byte[8];
        rand.nextBytes(randomBytes);
        return new BigInteger(1, randomBytes).toString(RADIX);
    }

    public static String humanize(String text) {
        String result = text.trim();
        Pattern pattern = Pattern.compile("(.*?)(\\[.*\\])");
        Matcher matcher = pattern.matcher(result);
        String params = "";
        if (matcher.matches()) {
            result = matcher.group(1);
            params = String.valueOf(' ') + matcher.group(2);
        }
        result = TextUtils.simplify(result);
        result = TextUtils.splitCamelCaseWordsWithLowdashes(result);
        result = TextUtils.lowdashesToSpaces(result);
        result = TextUtils.underscoreCapFirstWords(result);
        result = TextUtils.capitalize(result);
        return String.valueOf(result) + params;
    }

    public static String lowdashesToSpaces(String text) {
        return text.replaceAll("(_)+", " ");
    }

    public static String simplify(String text) {
        return text.replaceAll(".*\\.([^.]+)", "$1");
    }

    public static String capitalize(String text) {
        if (text.isEmpty()) {
            return text;
        }
        return String.valueOf(Character.toUpperCase(text.charAt(0))) + text.substring(1);
    }

    public static String underscoreCapFirstWords(String text) {
        Matcher matcher = Pattern.compile("(^|\\w|\\s)([A-Z]+)([a-z]+)").matcher(text);
        StringBuilder sb = new StringBuilder();
        int last = 0;
        while (matcher.find()) {
            sb.append(text.substring(last, matcher.start()));
            sb.append(matcher.group(0).toLowerCase());
            last = matcher.end();
        }
        sb.append(text.substring(last));
        return sb.toString();
    }

    public static String splitCamelCaseWordsWithLowdashes(String camelCaseString) {
        return camelCaseString.replaceAll(String.format("%s|%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[a-z0-9])(?=[A-Z])", "(?<=[A-Za-z])(?=[0-9])", "(?<=[A-Za-z0-9])(?=[\\[])"), "_");
    }

    public static String getMessageMask(String message) {
        return message == null ? "" : message.replaceAll("\\s+", " ");
    }

    public static String getIssueUrl(String name) {
        return String.format(AllureConfig.newInstance().getIssueTrackerPattern(), name);
    }

    public static String getTestUrl(String name) {
        return String.format(AllureConfig.newInstance().getTmsPattern(), name);
    }

    public static String processMarkdown(String rawText) {
        return new PegDownProcessor(262143).markdownToHtml(rawText);
    }
}

