/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.data.plugins;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.allure.data.plugins.Plugin;
import ru.yandex.qatools.allure.data.plugins.PluginData;
import ru.yandex.qatools.allure.data.plugins.WithData;
import ru.yandex.qatools.allure.data.plugins.WithPriority;
import ru.yandex.qatools.allure.data.plugins.WithResources;

public abstract class AbstractPlugin
implements WithResources,
WithData,
WithPriority {
    public static final Logger LOGGER = LoggerFactory.getLogger(AbstractPlugin.class);
    private String name = this.getClass().isAnnotationPresent(Plugin.Name.class) ? this.getClass().getAnnotation(Plugin.Name.class).value() : null;
    private int priority = this.getClass().isAnnotationPresent(Plugin.Priority.class) ? this.getClass().getAnnotation(Plugin.Priority.class).value() : 0;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public List<PluginData> getPluginData() {
        ArrayList<PluginData> results = new ArrayList<PluginData>();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Plugin.Data.class)) continue;
            String fileName = this.getFileName(field);
            results.add(new PluginData(fileName, this.getFieldValue(field)));
        }
        return results;
    }

    private Object getFieldValue(Field field) {
        try {
            field.setAccessible(true);
            return field.get(this);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Can't access to field value", (Throwable)e);
            return null;
        }
    }

    private String getFileName(Field field) {
        String fileName = field.getAnnotation(Plugin.Data.class).value();
        if ("##default".equals(fileName)) {
            fileName = this.getName() + ".json";
        }
        return fileName;
    }

    public static boolean isValid(Class<? extends AbstractPlugin> pluginClass) {
        return pluginClass != null && pluginClass.isAnnotationPresent(Plugin.Name.class) && AbstractPlugin.checkModifiers(pluginClass) && AbstractPlugin.checkFieldsWithDataAnnotation(pluginClass);
    }

    private static boolean checkModifiers(Class<? extends AbstractPlugin> pluginClass) {
        int modifiers = pluginClass.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers) && !Modifier.isPrivate(modifiers);
    }

    private static boolean checkFieldsWithDataAnnotation(Class<? extends AbstractPlugin> pluginClass) {
        ArrayList<Field> dataFields = new ArrayList<Field>();
        for (Field field : pluginClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Plugin.Data.class)) continue;
            dataFields.add(field);
        }
        return AbstractPlugin.shouldHasUniqueValues(dataFields);
    }

    private static boolean shouldHasUniqueValues(List<Field> dataFields) {
        HashSet<String> dataValues = new HashSet<String>();
        for (Field field : dataFields) {
            String value = field.getAnnotation(Plugin.Data.class).value();
            if (dataValues.contains(value)) {
                return false;
            }
            dataValues.add(value);
        }
        return true;
    }
}

