/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.clay;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.resolution.ArtifactResult;
import ru.yandex.qatools.clay.AetherException;

public class AetherResult {
    private List<ArtifactResult> results;

    AetherResult(List<ArtifactResult> results) {
        this.results = results;
    }

    public List<ArtifactResult> get() {
        return this.results;
    }

    public URLClassLoader getAsClassLoader() throws AetherException {
        return this.getAsClassLoader(false);
    }

    public URLClassLoader getAsClassLoader(boolean failOnError) throws AetherException {
        return this.getAsClassLoader(null, failOnError);
    }

    public URLClassLoader getAsClassLoader(ClassLoader parent) throws AetherException {
        return this.getAsClassLoader(parent, false);
    }

    public URLClassLoader getAsClassLoader(ClassLoader parent, boolean failOnError) throws AetherException {
        return new URLClassLoader(this.getAsUrls(failOnError), parent);
    }

    public URL[] getAsUrls() throws AetherException {
        return this.getAsUrls(false);
    }

    public URL[] getAsUrls(boolean failOnError) throws AetherException {
        List<URL> urls = this.getAs(new Converter<URL>(){

            @Override
            public boolean check(ArtifactResult result) {
                return result != null && result.getArtifact() != null && result.getArtifact().getFile() != null;
            }

            @Override
            public URL convert(ArtifactResult result) throws AetherException {
                try {
                    return result.getArtifact().getFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new AetherException(e);
                }
            }
        }, failOnError);
        return urls.toArray(new URL[urls.size()]);
    }

    public String[] getAsClassPath() throws AetherException {
        return this.getAsClassPath(false);
    }

    public String[] getAsClassPath(boolean failOnError) throws AetherException {
        List<String> strings = this.getAs(new Converter<String>(){

            @Override
            public boolean check(ArtifactResult result) {
                return result != null && result.getArtifact() != null && result.getArtifact().getFile() != null;
            }

            @Override
            public String convert(ArtifactResult result) throws AetherException {
                try {
                    return result.getArtifact().getFile().toURI().toURL().toString();
                }
                catch (MalformedURLException e) {
                    throw new AetherException(e);
                }
            }
        }, failOnError);
        return strings.toArray(new String[strings.size()]);
    }

    public <T> List<T> getAs(Converter<T> converter, boolean failOnError) throws AetherException {
        ArrayList<T> converted = new ArrayList<T>();
        for (ArtifactResult result : this.results) {
            if (converter.check(result)) {
                try {
                    converted.add(converter.convert(result));
                    continue;
                }
                catch (Exception e) {
                    if (!failOnError) continue;
                    throw new AetherException("Can't convert artifact result", e);
                }
            }
            if (!failOnError) continue;
            throw new AetherException("Artifact result " + result + " doesn't contains file");
        }
        return converted;
    }

    public static interface Converter<T> {
        public boolean check(ArtifactResult var1);

        public T convert(ArtifactResult var1) throws AetherException;
    }
}

