/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.clay.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.Deployer;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.LocalRepositoryProvider;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultDependencyCollector;
import org.eclipse.aether.internal.impl.DefaultDeployer;
import org.eclipse.aether.internal.impl.DefaultInstaller;
import org.eclipse.aether.internal.impl.DefaultLocalRepositoryProvider;
import org.eclipse.aether.internal.impl.DefaultMetadataResolver;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.internal.impl.DefaultSyncContextFactory;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;

public final class AetherUtils {
    AetherUtils() {
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultRepositorySystem repositorySystem = new DefaultRepositorySystem();
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setService(LoggerFactory.class, NullLoggerFactory.class);
        locator.setService(VersionResolver.class, DefaultVersionResolver.class);
        locator.setService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.setService(ArtifactResolver.class, DefaultArtifactResolver.class);
        locator.setService(MetadataResolver.class, DefaultMetadataResolver.class);
        locator.setService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.setService(DependencyCollector.class, DefaultDependencyCollector.class);
        locator.setService(Installer.class, DefaultInstaller.class);
        locator.setService(Deployer.class, DefaultDeployer.class);
        locator.setService(LocalRepositoryProvider.class, DefaultLocalRepositoryProvider.class);
        locator.setService(SyncContextFactory.class, DefaultSyncContextFactory.class);
        repositorySystem.initService((ServiceLocator)locator);
        return repositorySystem;
    }

    public static RepositorySystemSession newSession(RepositorySystem system, Settings settings, File localRepoDir) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localRepoDir.getAbsolutePath());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setUpdatePolicy("always");
        if (settings != null) {
            session.setOffline(settings.isOffline());
            session.setMirrorSelector(AetherUtils.newMirrorSelector(settings.getMirrors()));
            session.setAuthenticationSelector(AetherUtils.newAuthSelector(settings.getServers()));
            session.setCache((RepositoryCache)new DefaultRepositoryCache());
            session.setProxySelector(AetherUtils.newProxySelector(settings.getProxies()));
        }
        return session;
    }

    public static ProxySelector newProxySelector(List<org.apache.maven.settings.Proxy> proxies) {
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy proxy : proxies) {
            Authentication auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
            proxySelector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth), proxy.getNonProxyHosts());
        }
        return proxySelector;
    }

    public static MirrorSelector newMirrorSelector(List<Mirror> mirrors) {
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror mirror : mirrors) {
            selector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        return selector;
    }

    public static AuthenticationSelector newAuthSelector(List<Server> servers) {
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        for (Server server : servers) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(server.getUsername()).addPassword(server.getPassword());
            auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            selector.add(server.getId(), auth.build());
        }
        return new ConservativeAuthenticationSelector((AuthenticationSelector)selector);
    }

    public static List<RemoteRepository> getRepositoriesAsList(RepositorySystemSession session, Settings settings) {
        if (settings == null) {
            return Collections.emptyList();
        }
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        for (String profileName : settings.getActiveProfiles()) {
            Profile profile = (Profile)settings.getProfilesAsMap().get(profileName);
            for (Repository repository : profile.getRepositories()) {
                repositories.add(AetherUtils.toRemoteRepository(repository, session));
            }
        }
        return repositories;
    }

    public static RemoteRepository toRemoteRepository(Repository repo, RepositorySystemSession session) {
        RemoteRepository.Builder prototypeBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
        prototypeBuilder.setSnapshotPolicy(AetherUtils.transformPolicy(repo.getSnapshots()));
        prototypeBuilder.setReleasePolicy(AetherUtils.transformPolicy(repo.getReleases()));
        RemoteRepository prototype = prototypeBuilder.build();
        RemoteRepository.Builder builder = new RemoteRepository.Builder(prototype);
        builder.setAuthentication(session.getAuthenticationSelector().getAuthentication(prototype));
        builder.setProxy(session.getProxySelector().getProxy(prototype));
        builder.setMirroredRepositories(Arrays.asList(session.getMirrorSelector().getMirror(prototype)));
        return builder.build();
    }

    public static RemoteRepository toRemoteRepository(org.apache.maven.model.Repository repo, RepositorySystemSession session) {
        RemoteRepository.Builder prototypeBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
        prototypeBuilder.setSnapshotPolicy(AetherUtils.transformPolicy(repo.getSnapshots()));
        prototypeBuilder.setReleasePolicy(AetherUtils.transformPolicy(repo.getReleases()));
        RemoteRepository prototype = prototypeBuilder.build();
        RemoteRepository.Builder builder = new RemoteRepository.Builder(prototype);
        builder.setAuthentication(session.getAuthenticationSelector().getAuthentication(prototype));
        builder.setProxy(session.getProxySelector().getProxy(prototype));
        builder.setMirroredRepositories(Arrays.asList(session.getMirrorSelector().getMirror(prototype)));
        return builder.build();
    }

    public static RepositoryPolicy transformPolicy(org.apache.maven.model.RepositoryPolicy policy) {
        return policy == null ? null : AetherUtils.newRepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy());
    }

    public static RepositoryPolicy transformPolicy(org.apache.maven.settings.RepositoryPolicy policy) {
        return policy == null ? null : AetherUtils.newRepositoryPolicy(policy.isEnabled(), policy.getUpdatePolicy(), policy.getChecksumPolicy());
    }

    public static RepositoryPolicy newRepositoryPolicy(boolean enabled, String updatePolicy, String checksumPolicy) {
        return new RepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }
}

