/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.clay.aether;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Repository;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import ru.qatools.clay.aether.AetherException;
import ru.qatools.clay.aether.AetherResult;
import ru.qatools.clay.aether.internal.AetherUtils;
import ru.qatools.clay.maven.settings.FluentModelBuilder;

public class Aether {
    public static final String MAVEN_CENTRAL_URL = "http://repo1.maven.org/maven2";
    public static final String POM_EXTENSION = "pom";
    public static final String MODEL_VERSION = "4.0.0";
    public static final String JAR = "jar";
    public static final String POM_XML = "pom.xml";
    public static final String AETHER_TEMP_FILE_PREFIX = "clay-aether";
    private RepositorySystemSession session;
    private RepositorySystem system;
    private List<RemoteRepository> repositories;
    private String scope = "runtime";

    Aether(File localRepoDir, Settings settings) {
        this.system = AetherUtils.newRepositorySystem();
        this.session = AetherUtils.newSession(this.system, settings, localRepoDir);
        this.repositories = AetherUtils.getRepositoriesAsList(this.session, settings);
    }

    Aether(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> repositories) {
        this.session = session;
        this.system = system;
        this.repositories = repositories;
    }

    public static Aether aether(File localRepoDir) {
        return Aether.aether(localRepoDir, null);
    }

    public static Aether aether(File localRepoDir, Settings settings) {
        return new Aether(localRepoDir, settings);
    }

    public static Aether aether(Settings settings) {
        return new Aether(new File(settings.getLocalRepository()), settings);
    }

    public static Aether aether(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> repositories) {
        return new Aether(system, session, repositories);
    }

    public Aether scope(String scope) {
        this.scope = scope;
        return this;
    }

    public AetherResult resolve(String artifactCoordinates) throws AetherException {
        return this.resolve((Artifact)new DefaultArtifact(artifactCoordinates));
    }

    public AetherResult resolve(Artifact artifact) throws AetherException {
        return this.resolve(artifact, true);
    }

    public AetherResult resolve(String artifactCoordinates, boolean withTransitives) throws AetherException {
        return this.resolve((Artifact)new DefaultArtifact(artifactCoordinates), withTransitives);
    }

    public AetherResult resolve(Artifact artifact, boolean withTransitives) throws AetherException {
        return withTransitives ? this.resolveWithTransitives(artifact) : this.resolveWithoutTransitives(artifact);
    }

    public AetherResult resolveAll(String ... artifactsCoordinates) throws AetherException {
        ArrayList<DefaultArtifact> artifacts = new ArrayList<DefaultArtifact>();
        for (String coordinate : artifactsCoordinates) {
            artifacts.add(new DefaultArtifact(coordinate));
        }
        return this.resolveAll(artifacts.toArray(new Artifact[artifacts.size()]));
    }

    public AetherResult resolveAll(Artifact ... artifacts) throws AetherException {
        return this.resolveWithoutTransitives(artifacts);
    }

    protected AetherResult resolveWithTransitives(Artifact artifact) throws AetherException {
        try {
            CollectRequest collectRequest = new CollectRequest(new Dependency(artifact, this.scope), this.repositories());
            DependencyRequest request = new DependencyRequest(collectRequest, null);
            return new AetherResult(this.system.resolveDependencies(this.session, request).getArtifactResults());
        }
        catch (DependencyResolutionException e) {
            throw new AetherException("Can't resolve given artifact " + artifact, e);
        }
    }

    protected AetherResult resolveWithoutTransitives(Artifact ... artifacts) throws AetherException {
        try {
            return new AetherResult(this.system.resolveArtifacts(this.session, this.buildArtifactRequests(artifacts)));
        }
        catch (ArtifactResolutionException e) {
            throw new AetherException("Can't resolve one or more given artifacts " + Arrays.toString(artifacts), e);
        }
    }

    protected List<ArtifactRequest> buildArtifactRequests(Artifact ... artifacts) {
        ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
        for (Artifact artifact : artifacts) {
            requests.add(new ArtifactRequest(artifact, this.repositories(), null));
        }
        return requests;
    }

    public List<Artifact> collect(String artifactCoordinates) throws AetherException {
        return this.collect((Artifact)new DefaultArtifact(artifactCoordinates));
    }

    public List<Artifact> collect(Artifact artifact) throws AetherException {
        try {
            if (this.session.isOffline()) {
                throw new AetherException("Can't collect dependencies in offline mode");
            }
            CollectRequest collectRequest = new CollectRequest(new Dependency(artifact, this.scope), this.repositories());
            CollectResult result = this.system.collectDependencies(this.session, collectRequest);
            PreorderNodeListGenerator visitor = new PreorderNodeListGenerator();
            result.getRoot().accept((DependencyVisitor)visitor);
            return visitor.getArtifacts(true);
        }
        catch (DependencyCollectionException e) {
            throw new AetherException("Can't collect given artifact " + artifact, e);
        }
    }

    public void install(File jar, String groupId, String artifactId, String version) throws AetherException {
        this.install(jar, groupId, artifactId, JAR, version);
    }

    public void install(File jar, String groupId, String artifactId, String extension, String version) throws AetherException {
        this.install(jar, groupId, artifactId, "", extension, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(File jar, String groupId, String artifactId, String classifier, String extension, String version) throws AetherException {
        File pom = null;
        try {
            pom = this.createPomFile(groupId, artifactId, version);
            this.install(jar, pom, groupId, artifactId, classifier, extension, version);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(pom);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)pom);
    }

    public void install(File jar, File pom, String groupId, String artifactId, String classifier, String extension, String version) throws AetherException {
        DefaultArtifact jarArtifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version, null, jar);
        SubArtifact pomArtifact = new SubArtifact((Artifact)jarArtifact, null, POM_EXTENSION, pom);
        this.install(new Artifact[]{jarArtifact, pomArtifact});
    }

    public void install(Artifact ... artifacts) throws AetherException {
        try {
            InstallRequest installRequest = new InstallRequest();
            for (Artifact artifact : artifacts) {
                installRequest.addArtifact(artifact);
            }
            this.system.install(this.session, installRequest);
        }
        catch (InstallationException e) {
            throw new AetherException("Can't install one or more given artifacts " + Arrays.toString(artifacts), e);
        }
    }

    public void deploy(DistributionManagement distribution, File jar, String groupId, String artifactId, String version) throws AetherException {
        this.deploy(distribution, jar, groupId, artifactId, JAR, version);
    }

    public void deploy(DistributionManagement distribution, File jar, String groupId, String artifactId, String extension, String version) throws AetherException {
        this.deploy(distribution, jar, groupId, artifactId, "", extension, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DistributionManagement distribution, File jar, String groupId, String artifactId, String classifier, String extension, String version) throws AetherException {
        File pom = null;
        try {
            pom = this.createPomFile(groupId, artifactId, version);
            this.deploy(distribution, jar, pom, groupId, artifactId, classifier, extension, version);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(pom);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)pom);
    }

    public void deploy(DistributionManagement distribution, File jar, File pom, String groupId, String artifactId, String classifier, String extension, String version) throws AetherException {
        DefaultArtifact jarArtifact = new DefaultArtifact(groupId, artifactId, classifier, extension, version, null, jar);
        SubArtifact pomArtifact = new SubArtifact((Artifact)jarArtifact, null, POM_EXTENSION, pom);
        this.deploy(distribution, new Artifact[]{jarArtifact, pomArtifact});
    }

    public void deploy(DistributionManagement distribution, Artifact ... artifacts) throws AetherException {
        try {
            if (artifacts.length == 0) {
                return;
            }
            DeployRequest deployRequest = new DeployRequest();
            for (Artifact artifact : artifacts) {
                deployRequest.addArtifact(artifact);
            }
            deployRequest.setRepository(AetherUtils.toRemoteRepository((Repository)(artifacts[0].isSnapshot() ? distribution.getSnapshotRepository() : distribution.getRepository()), this.session));
            this.system.deploy(this.session, deployRequest);
        }
        catch (DeploymentException e) {
            throw new AetherException("Can't deploy one or more given artifacts" + Arrays.toString(artifacts), e);
        }
    }

    protected File createPomFile(String groupId, String artifactId, String version) throws AetherException {
        try {
            File pom = File.createTempFile(AETHER_TEMP_FILE_PREFIX, POM_XML);
            FluentModelBuilder.newPom().withGroupId(groupId).withArtifactId(artifactId).withVersion(version).withModelVersion(MODEL_VERSION).marshalTo(pom);
            return pom;
        }
        catch (IOException e) {
            throw new AetherException("Can't create temp file for pom.xml", e);
        }
    }

    protected List<RemoteRepository> repositories() {
        return this.session.isOffline() ? null : this.repositories;
    }
}

