/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.clay.maven.settings;

import java.io.File;
import java.io.FileNotFoundException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.codehaus.plexus.util.FileUtils;
import ru.qatools.clay.maven.settings.FluentMirrorBuilder;
import ru.qatools.clay.maven.settings.FluentProfileBuilder;
import ru.qatools.clay.maven.settings.FluentProxyBuilder;
import ru.qatools.clay.maven.settings.FluentServerBuilder;
import ru.qatools.clay.maven.settings.MavenDefaults;

public class FluentSettingsBuilder {
    private final Settings settings;

    private FluentSettingsBuilder(Settings settings) {
        this.settings = settings;
    }

    public static FluentSettingsBuilder newSettings() {
        Settings settings = new Settings();
        settings.setLocalRepository(MavenDefaults.getDefaultLocalRepository());
        return new FluentSettingsBuilder(settings);
    }

    public static FluentSettingsBuilder loadSettings() throws FileNotFoundException, SettingsBuildingException {
        String settingsPath = MavenDefaults.getDefaultSystemSettings();
        if (settingsPath != null && FileUtils.fileExists((String)settingsPath)) {
            return FluentSettingsBuilder.loadSettings(settingsPath);
        }
        return FluentSettingsBuilder.newSettings();
    }

    public static FluentSettingsBuilder loadSettings(String settingsFilePath) throws FileNotFoundException, SettingsBuildingException {
        return FluentSettingsBuilder.loadSettings(new File(settingsFilePath));
    }

    public static FluentSettingsBuilder loadSettings(File settingsFile) throws FileNotFoundException, SettingsBuildingException {
        if (settingsFile == null) {
            throw new NullPointerException("Settings file can't be null");
        }
        if (!settingsFile.exists()) {
            throw new FileNotFoundException(String.format("Settings file [%s] not found", settingsFile.getAbsoluteFile()));
        }
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setGlobalSettingsFile(settingsFile);
        Settings settings = new DefaultSettingsBuilderFactory().newInstance().build((SettingsBuildingRequest)request).getEffectiveSettings();
        if (settings.getLocalRepository() == null) {
            settings.setLocalRepository(MavenDefaults.getDefaultLocalRepository());
        }
        return new FluentSettingsBuilder(settings);
    }

    @Deprecated
    public static FluentSettingsBuilder newSettings(String settingsFilePath) throws SettingsBuildingException {
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setGlobalSettingsFile(new File(settingsFilePath));
        Settings settings = new DefaultSettingsBuilderFactory().newInstance().build((SettingsBuildingRequest)request).getEffectiveSettings();
        return new FluentSettingsBuilder(settings);
    }

    @Deprecated
    public static FluentSettingsBuilder newSystemSettings() {
        String m2home;
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            String settingsPath = String.format("%s/.m2/settings.xml", userHome);
            try {
                return FluentSettingsBuilder.newSettings(settingsPath);
            }
            catch (SettingsBuildingException ignored) {
                // empty catch block
            }
        }
        if ((m2home = System.getProperty("maven.home", System.getProperty("M2_HOME"))) != null) {
            String settingsPath = String.format("%s/conf/settings.xml", m2home);
            try {
                return FluentSettingsBuilder.newSettings(settingsPath);
            }
            catch (SettingsBuildingException settingsBuildingException) {
                // empty catch block
            }
        }
        return FluentSettingsBuilder.newSettings();
    }

    public Settings build() {
        return this.settings;
    }

    public FluentSettingsBuilder withLocalRepository(String localRepository) {
        if (localRepository == null) {
            return this;
        }
        this.settings.setLocalRepository(localRepository);
        return this;
    }

    public FluentSettingsBuilder withLocalRepository(File localRepository) {
        if (localRepository == null) {
            return this;
        }
        this.settings.setLocalRepository(localRepository.getAbsolutePath());
        return this;
    }

    public FluentSettingsBuilder withMirror(FluentMirrorBuilder mirror) {
        return this.withMirror(mirror.build());
    }

    public FluentSettingsBuilder withMirror(Mirror mirror) {
        this.settings.addMirror(mirror);
        return this;
    }

    public FluentSettingsBuilder withPluginGroup(String string) {
        this.settings.addPluginGroup(string);
        return this;
    }

    public FluentSettingsBuilder withProfile(FluentProfileBuilder profile) {
        return this.withProfile(profile.build());
    }

    public FluentSettingsBuilder withProfile(Profile profile) {
        this.settings.addProfile(profile);
        return this;
    }

    public FluentSettingsBuilder withActiveProfile(FluentProfileBuilder profile) {
        return this.withActiveProfile(profile.build());
    }

    protected FluentSettingsBuilder withActiveProfile(Profile profile) {
        this.settings.addProfile(profile);
        this.settings.addActiveProfile(profile.getId());
        return this;
    }

    public FluentSettingsBuilder withActiveProfile(String string) {
        this.settings.addActiveProfile(string);
        return this;
    }

    public FluentSettingsBuilder withProxy(FluentProxyBuilder proxy) {
        return this.withProxy(proxy.build());
    }

    public FluentSettingsBuilder withProxy(Proxy proxy) {
        this.settings.addProxy(proxy);
        return this;
    }

    public FluentSettingsBuilder withServer(FluentServerBuilder server) {
        return this.withServer(server.build());
    }

    public FluentSettingsBuilder withServer(Server server) {
        this.settings.addServer(server);
        return this;
    }

    public FluentSettingsBuilder withOffline(boolean offline) {
        this.settings.setOffline(offline);
        return this;
    }
}

