/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.clay.utils.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import ru.yandex.qatools.clay.utils.archive.DefaultJarEntryFilter;
import ru.yandex.qatools.clay.utils.archive.JarEntryFilter;

public final class ArchiveUtil {
    ArchiveUtil() {
    }

    public static void unpackJar(File source, File destination) throws IOException {
        ArchiveUtil.unpackJar(source, destination, (JarEntryFilter)new DefaultJarEntryFilter());
    }

    public static void unpackJar(File source, File destination, JarEntryFilter filter) throws IOException {
        ArchiveUtil.unpackJar(new JarFile(source), destination, filter);
    }

    public static void unpackJar(JarFile source, File destination, JarEntryFilter filter) throws IOException {
        Enumeration<JarEntry> entries = source.entries();
        while (entries.hasMoreElements()) {
            JarEntry entryToCopy = entries.nextElement();
            if (!filter.accept(entryToCopy)) continue;
            File outputFile = new File(destination, filter.getOutputFilePath(entryToCopy));
            if (entryToCopy.isDirectory()) {
                FileUtils.forceMkdir((File)outputFile);
                continue;
            }
            FileUtils.copyInputStreamToFile((InputStream)source.getInputStream(entryToCopy), (File)outputFile);
        }
    }
}

