/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
public final class TtlTimerTask
extends TimerTask {
    private final AtomicReference<Map<TransmittableThreadLocal<?>, Object>> copiedRef = new AtomicReference(TransmittableThreadLocal.copy());
    private final TimerTask timerTask;
    private final boolean releaseTtlValueReferenceAfterRun;

    private TtlTimerTask(TimerTask timerTask, boolean releaseTtlValueReferenceAfterRun) {
        this.timerTask = timerTask;
        this.releaseTtlValueReferenceAfterRun = releaseTtlValueReferenceAfterRun;
    }

    @Override
    public void run() {
        Map<TransmittableThreadLocal<?>, Object> copied = this.copiedRef.get();
        if (copied == null || this.releaseTtlValueReferenceAfterRun && !this.copiedRef.compareAndSet(copied, null)) {
            throw new IllegalStateException("TTL value reference is released after run!");
        }
        Map<TransmittableThreadLocal<?>, Object> backup = TransmittableThreadLocal.backupAndSetToCopied(copied);
        try {
            this.timerTask.run();
        }
        finally {
            TransmittableThreadLocal.restoreBackup(backup);
        }
    }

    @Override
    public boolean cancel() {
        this.timerTask.cancel();
        return super.cancel();
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public static TtlTimerTask get(TimerTask timerTask) {
        return TtlTimerTask.get(timerTask, false, false);
    }

    public static TtlTimerTask get(TimerTask timerTask, boolean releaseTtlValueReferenceAfterRun) {
        return TtlTimerTask.get(timerTask, releaseTtlValueReferenceAfterRun, false);
    }

    public static TtlTimerTask get(TimerTask timerTask, boolean releaseTtlValueReferenceAfterRun, boolean idempotent) {
        if (null == timerTask) {
            return null;
        }
        if (timerTask instanceof TtlTimerTask) {
            if (idempotent) {
                return (TtlTimerTask)timerTask;
            }
            throw new IllegalStateException("Already TtlTimerTask!");
        }
        return new TtlTimerTask(timerTask, false);
    }
}

