package com.aliyun.openservices.ons.api.order;

import com.aliyun.openservices.ons.api.Admin;


/**
 * 顺序消息消费者接口
 */
public interface OrderConsumer extends Admin {
    /**
     * 启动服务
     */
    public void start();


    /**
     * 关闭服务
     */
    public void shutdown();


    /**
     * 订阅消息
     *
     * @param topic
     *         消息主题
     * @param subExpression
     *         订阅过滤表达式字符串，broker依据此表达式进行过滤。目前只支持或运算<br>
     *         eg: "tag1 || tag2 || tag3"<br>
     *         如果subExpression等于null或者*，则表示全部订阅
     * @param listener
     *         消息回调监听器
     */
    public void subscribe(final String topic, final String subExpression, final MessageOrderListener listener);
}
