/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.rtsp;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.UnsupportedMessageTypeException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.HttpMessage;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.HttpObjectEncoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.shade.io.netty.util.internal.StringUtil;

public class RtspEncoder
extends HttpObjectEncoder<HttpMessage> {
    private static final byte[] CRLF = new byte[]{13, 10};

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && (msg instanceof HttpRequest || msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpMessage message) throws Exception {
        if (message instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)message;
            HttpHeaders.encodeAscii(request.getMethod().toString(), buf);
            buf.writeByte(32);
            buf.writeBytes(request.getUri().getBytes(CharsetUtil.UTF_8));
            buf.writeByte(32);
            HttpHeaders.encodeAscii(request.getProtocolVersion().toString(), buf);
            buf.writeBytes(CRLF);
        } else if (message instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)message;
            HttpHeaders.encodeAscii(response.getProtocolVersion().toString(), buf);
            buf.writeByte(32);
            buf.writeBytes(String.valueOf(response.getStatus().code()).getBytes(CharsetUtil.US_ASCII));
            buf.writeByte(32);
            HttpHeaders.encodeAscii(String.valueOf(response.getStatus().reasonPhrase()), buf);
            buf.writeBytes(CRLF);
        } else {
            throw new UnsupportedMessageTypeException("Unsupported type " + StringUtil.simpleClassName(message));
        }
    }
}

