/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.api;

import com.dangdang.ddframe.job.api.JobExecutionSingleShardingContext;
import com.dangdang.ddframe.job.exception.JobException;
import com.dangdang.ddframe.job.internal.job.AbstractJobExecutionShardingContext;
import com.google.gson.Gson;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public final class JobExecutionMultipleShardingContext
extends AbstractJobExecutionShardingContext {
    private static int initCollectionSize = 64;
    private List<Integer> shardingItems = new ArrayList<Integer>(initCollectionSize);
    private Map<Integer, String> shardingItemParameters = new HashMap<Integer, String>(initCollectionSize);
    private Map<Integer, String> offsets = new HashMap<Integer, String>();

    public JobExecutionSingleShardingContext createJobExecutionSingleShardingContext(int item) {
        JobExecutionSingleShardingContext result = new JobExecutionSingleShardingContext();
        try {
            BeanUtils.copyProperties((Object)result, (Object)this);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new JobException(ex);
        }
        result.setShardingItem(item);
        result.setShardingItemParameter(this.shardingItemParameters.get(item));
        result.setOffset(this.offsets.get(item));
        return result;
    }

    public String toString() {
        return String.format("jobName: %s, shardingTotalCount: %s, shardingItems: %s, shardingItemParameters: %s, jobParameter: %s", this.getJobName(), this.getShardingTotalCount(), this.shardingItems, this.shardingItemParameters, this.getJobParameter());
    }

    public String toScriptArguments() {
        return new Gson().toJson((Object)this);
    }

    public List<Integer> getShardingItems() {
        return this.shardingItems;
    }

    public Map<Integer, String> getShardingItemParameters() {
        return this.shardingItemParameters;
    }

    public Map<Integer, String> getOffsets() {
        return this.offsets;
    }

    public void setShardingItems(List<Integer> shardingItems) {
        this.shardingItems = shardingItems;
    }

    public void setOffsets(Map<Integer, String> offsets) {
        this.offsets = offsets;
    }
}

