/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.api;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.exception.JobException;
import com.dangdang.ddframe.job.internal.executor.JobExecutor;
import com.dangdang.ddframe.job.internal.job.LiteJob;
import com.dangdang.ddframe.job.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Joiner;
import java.util.Properties;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerListener;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;

public class JobScheduler {
    private static final String SCHEDULER_INSTANCE_NAME_SUFFIX = "Scheduler";
    private static final String CRON_TRIGGER_IDENTITY_SUFFIX = "Trigger";
    private final JobExecutor jobExecutor;

    public JobScheduler(CoordinatorRegistryCenter regCenter, JobConfiguration jobConfig, ElasticJobListener ... elasticJobListeners) {
        this.jobExecutor = new JobExecutor(regCenter, jobConfig, elasticJobListeners);
    }

    public void init() {
        JobScheduleController jobScheduleController;
        this.jobExecutor.init();
        JobDetail jobDetail = JobBuilder.newJob(LiteJob.class).withIdentity(this.jobExecutor.getJobName()).build();
        jobDetail.getJobDataMap().put("elasticJob", (Object)this.jobExecutor.getElasticJob());
        try {
            jobScheduleController = new JobScheduleController(this.initializeScheduler(jobDetail.getKey().toString()), jobDetail, this.jobExecutor.getSchedulerFacade(), Joiner.on((String)"_").join((Object)this.jobExecutor.getJobName(), (Object)CRON_TRIGGER_IDENTITY_SUFFIX, new Object[0]));
            jobScheduleController.scheduleJob(this.jobExecutor.getSchedulerFacade().getCron());
        }
        catch (SchedulerException ex) {
            throw new JobException(ex);
        }
        JobRegistry.getInstance().addJobScheduleController(this.jobExecutor.getJobName(), jobScheduleController);
    }

    private Scheduler initializeScheduler(String jobName) throws SchedulerException {
        StdSchedulerFactory factory = new StdSchedulerFactory();
        factory.initialize(this.getBaseQuartzProperties(jobName));
        Scheduler result = factory.getScheduler();
        result.getListenerManager().addTriggerListener((TriggerListener)this.jobExecutor.getSchedulerFacade().newJobTriggerListener());
        return result;
    }

    private Properties getBaseQuartzProperties(String jobName) {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        result.put("org.quartz.threadPool.threadCount", "1");
        result.put("org.quartz.scheduler.instanceName", Joiner.on((String)"_").join((Object)jobName, (Object)SCHEDULER_INSTANCE_NAME_SUFFIX, new Object[0]));
        if (!this.jobExecutor.getSchedulerFacade().isMisfire()) {
            result.put("org.quartz.jobStore.misfireThreshold", "1");
        }
        this.prepareEnvironments(result);
        return result;
    }

    protected void prepareEnvironments(Properties props) {
    }
}

