/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.api.config.impl;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.api.config.impl.JobType;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.beans.ConstructorProperties;

public abstract class AbstractJobConfiguration<T extends ElasticJob>
implements JobConfiguration<T> {
    private final String jobName;
    private final JobType jobType;
    private final Class<? extends T> jobClass;
    private final int shardingTotalCount;
    private final String cron;
    private final String shardingItemParameters;
    private final String jobParameter;
    private final boolean monitorExecution;
    private final int maxTimeDiffSeconds;
    private final boolean failover;
    private final boolean misfire;
    private final int monitorPort;
    private final String jobShardingStrategyClass;
    private final String description;
    private final boolean disabled;
    private final boolean overwrite;

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public JobType getJobType() {
        return this.jobType;
    }

    @Override
    public Class<? extends T> getJobClass() {
        return this.jobClass;
    }

    @Override
    public int getShardingTotalCount() {
        return this.shardingTotalCount;
    }

    @Override
    public String getCron() {
        return this.cron;
    }

    @Override
    public String getShardingItemParameters() {
        return this.shardingItemParameters;
    }

    @Override
    public String getJobParameter() {
        return this.jobParameter;
    }

    @Override
    public boolean isMonitorExecution() {
        return this.monitorExecution;
    }

    @Override
    public int getMaxTimeDiffSeconds() {
        return this.maxTimeDiffSeconds;
    }

    @Override
    public boolean isFailover() {
        return this.failover;
    }

    @Override
    public boolean isMisfire() {
        return this.misfire;
    }

    @Override
    public int getMonitorPort() {
        return this.monitorPort;
    }

    @Override
    public String getJobShardingStrategyClass() {
        return this.jobShardingStrategyClass;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @ConstructorProperties(value={"jobName", "jobType", "jobClass", "shardingTotalCount", "cron", "shardingItemParameters", "jobParameter", "monitorExecution", "maxTimeDiffSeconds", "failover", "misfire", "monitorPort", "jobShardingStrategyClass", "description", "disabled", "overwrite"})
    public AbstractJobConfiguration(String jobName, JobType jobType, Class<? extends T> jobClass, int shardingTotalCount, String cron, String shardingItemParameters, String jobParameter, boolean monitorExecution, int maxTimeDiffSeconds, boolean failover, boolean misfire, int monitorPort, String jobShardingStrategyClass, String description, boolean disabled, boolean overwrite) {
        this.jobName = jobName;
        this.jobType = jobType;
        this.jobClass = jobClass;
        this.shardingTotalCount = shardingTotalCount;
        this.cron = cron;
        this.shardingItemParameters = shardingItemParameters;
        this.jobParameter = jobParameter;
        this.monitorExecution = monitorExecution;
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
        this.failover = failover;
        this.misfire = misfire;
        this.monitorPort = monitorPort;
        this.jobShardingStrategyClass = jobShardingStrategyClass;
        this.description = description;
        this.disabled = disabled;
        this.overwrite = overwrite;
    }

    public static abstract class AbstractJobConfigurationBuilder<T extends AbstractJobConfiguration, J extends ElasticJob, B extends AbstractJobConfigurationBuilder> {
        private final String jobName;
        private final JobType jobType;
        private final Class<? extends J> jobClass;
        private final int shardingTotalCount;
        private final String cron;
        private String shardingItemParameters = "";
        private String jobParameter = "";
        private boolean monitorExecution = true;
        private int maxTimeDiffSeconds = -1;
        private boolean failover;
        private boolean misfire = true;
        private int monitorPort = -1;
        private String jobShardingStrategyClass = "";
        private String description = "";
        private boolean disabled;
        private boolean overwrite;

        public B shardingItemParameters(String shardingItemParameters) {
            this.shardingItemParameters = shardingItemParameters;
            return (B)this;
        }

        public B jobParameter(String jobParameter) {
            this.jobParameter = jobParameter;
            return (B)this;
        }

        public B monitorExecution(boolean monitorExecution) {
            this.monitorExecution = monitorExecution;
            return (B)this;
        }

        public B maxTimeDiffSeconds(int maxTimeDiffSeconds) {
            this.maxTimeDiffSeconds = maxTimeDiffSeconds;
            return (B)this;
        }

        public B failover(boolean failover) {
            this.failover = failover;
            return (B)this;
        }

        public B misfire(boolean misfire) {
            this.misfire = misfire;
            return (B)this;
        }

        public B monitorPort(int monitorPort) {
            this.monitorPort = monitorPort;
            return (B)this;
        }

        public B jobShardingStrategyClass(String jobShardingStrategyClass) {
            this.jobShardingStrategyClass = jobShardingStrategyClass;
            return (B)this;
        }

        public B description(String description) {
            this.description = description;
            return (B)this;
        }

        public B disabled(boolean disabled) {
            this.disabled = disabled;
            return (B)this;
        }

        public B overwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return (B)this;
        }

        public final T build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.jobName) ? 1 : 0) != 0, (Object)"jobName can not be empty.");
            Preconditions.checkArgument((boolean)ElasticJob.class.isAssignableFrom(this.jobClass), (Object)"job class should be an instance of ElasticJob.");
            Preconditions.checkArgument((this.shardingTotalCount > 0 ? 1 : 0) != 0, (Object)"shardingTotalCount should larger than zero.");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.cron) ? 1 : 0) != 0, (Object)"cron can not be empty.");
            Preconditions.checkArgument((null != this.shardingItemParameters ? 1 : 0) != 0, (Object)"shardingItemParameters can not be null.");
            Preconditions.checkArgument((null != this.jobParameter ? 1 : 0) != 0, (Object)"jobParameter can not be null.");
            Preconditions.checkArgument((null != this.jobShardingStrategyClass ? 1 : 0) != 0, (Object)"jobShardingStrategyClass can not be null.");
            Preconditions.checkArgument((null != this.description ? 1 : 0) != 0, (Object)"description can not be null.");
            return this.buildInternal();
        }

        protected abstract T buildInternal();

        @ConstructorProperties(value={"jobName", "jobType", "jobClass", "shardingTotalCount", "cron"})
        protected AbstractJobConfigurationBuilder(String jobName, JobType jobType, Class<? extends J> jobClass, int shardingTotalCount, String cron) {
            this.jobName = jobName;
            this.jobType = jobType;
            this.jobClass = jobClass;
            this.shardingTotalCount = shardingTotalCount;
            this.cron = cron;
        }

        protected String getJobName() {
            return this.jobName;
        }

        protected JobType getJobType() {
            return this.jobType;
        }

        protected Class<? extends J> getJobClass() {
            return this.jobClass;
        }

        protected int getShardingTotalCount() {
            return this.shardingTotalCount;
        }

        protected String getCron() {
            return this.cron;
        }

        protected String getShardingItemParameters() {
            return this.shardingItemParameters;
        }

        protected String getJobParameter() {
            return this.jobParameter;
        }

        protected boolean isMonitorExecution() {
            return this.monitorExecution;
        }

        protected int getMaxTimeDiffSeconds() {
            return this.maxTimeDiffSeconds;
        }

        protected boolean isFailover() {
            return this.failover;
        }

        protected boolean isMisfire() {
            return this.misfire;
        }

        protected int getMonitorPort() {
            return this.monitorPort;
        }

        protected String getJobShardingStrategyClass() {
            return this.jobShardingStrategyClass;
        }

        protected String getDescription() {
            return this.description;
        }

        protected boolean isDisabled() {
            return this.disabled;
        }

        protected boolean isOverwrite() {
            return this.overwrite;
        }
    }
}

