/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.api.config.impl;

import com.dangdang.ddframe.job.api.DataFlowElasticJob;
import com.dangdang.ddframe.job.api.config.impl.AbstractJobConfiguration;
import com.dangdang.ddframe.job.api.config.impl.JobType;
import com.google.common.base.Preconditions;

public final class DataFlowJobConfiguration<T extends DataFlowElasticJob>
extends AbstractJobConfiguration<T> {
    private final int processCountIntervalSeconds;
    private final int fetchDataCount;
    private final int concurrentDataProcessThreadCount;
    private final boolean streamingProcess;

    private DataFlowJobConfiguration(String jobName, Class<? extends T> jobClass, int shardingTotalCount, String cron, String shardingItemParameters, String jobParameter, boolean monitorExecution, int maxTimeDiffSeconds, boolean isFailover, boolean isMisfire, int monitorPort, String jobShardingStrategyClass, String description, boolean disabled, boolean overwrite, int processCountIntervalSeconds, int fetchDataCount, int concurrentDataProcessThreadCount, boolean streamingProcess) {
        super(jobName, JobType.DATA_FLOW, jobClass, shardingTotalCount, cron, shardingItemParameters, jobParameter, monitorExecution, maxTimeDiffSeconds, isFailover, isMisfire, monitorPort, jobShardingStrategyClass, description, disabled, overwrite);
        this.processCountIntervalSeconds = processCountIntervalSeconds;
        this.fetchDataCount = fetchDataCount;
        this.concurrentDataProcessThreadCount = concurrentDataProcessThreadCount;
        this.streamingProcess = streamingProcess;
    }

    public int getProcessCountIntervalSeconds() {
        return this.processCountIntervalSeconds;
    }

    public int getFetchDataCount() {
        return this.fetchDataCount;
    }

    public int getConcurrentDataProcessThreadCount() {
        return this.concurrentDataProcessThreadCount;
    }

    public boolean isStreamingProcess() {
        return this.streamingProcess;
    }

    public static class DataFlowJobConfigurationBuilder
    extends AbstractJobConfiguration.AbstractJobConfigurationBuilder<DataFlowJobConfiguration, DataFlowElasticJob, DataFlowJobConfigurationBuilder> {
        private int processCountIntervalSeconds = 300;
        private int fetchDataCount = 1;
        private int concurrentDataProcessThreadCount = Runtime.getRuntime().availableProcessors() * 2;
        private boolean streamingProcess;

        public DataFlowJobConfigurationBuilder(String jobName, Class<? extends DataFlowElasticJob> jobClass, int shardingTotalCount, String cron) {
            super(jobName, JobType.DATA_FLOW, jobClass, shardingTotalCount, cron);
        }

        public final DataFlowJobConfigurationBuilder processCountIntervalSeconds(int processCountIntervalSeconds) {
            this.processCountIntervalSeconds = processCountIntervalSeconds;
            return this;
        }

        public final DataFlowJobConfigurationBuilder fetchDataCount(int fetchDataCount) {
            this.fetchDataCount = fetchDataCount;
            return this;
        }

        public final DataFlowJobConfigurationBuilder concurrentDataProcessThreadCount(int concurrentDataProcessThreadCount) {
            this.concurrentDataProcessThreadCount = concurrentDataProcessThreadCount;
            return this;
        }

        public final DataFlowJobConfigurationBuilder streamingProcess(boolean streamingProcess) {
            this.streamingProcess = streamingProcess;
            return this;
        }

        @Override
        protected DataFlowJobConfiguration buildInternal() {
            Preconditions.checkArgument((this.processCountIntervalSeconds > 0 ? 1 : 0) != 0, (Object)String.format("%d should larger than zero.", this.processCountIntervalSeconds));
            Preconditions.checkArgument((this.fetchDataCount > 0 ? 1 : 0) != 0, (Object)String.format("%d should larger than zero.", this.fetchDataCount));
            Preconditions.checkArgument((this.concurrentDataProcessThreadCount > 0 ? 1 : 0) != 0, (Object)String.format("%d should larger than zero.", this.concurrentDataProcessThreadCount));
            return new DataFlowJobConfiguration(this.getJobName(), this.getJobClass(), this.getShardingTotalCount(), this.getCron(), this.getShardingItemParameters(), this.getJobParameter(), this.isMonitorExecution(), this.getMaxTimeDiffSeconds(), this.isFailover(), this.isMisfire(), this.getMonitorPort(), this.getJobShardingStrategyClass(), this.getDescription(), this.isDisabled(), this.isOverwrite(), this.processCountIntervalSeconds, this.fetchDataCount, this.concurrentDataProcessThreadCount, this.streamingProcess);
        }
    }
}

