/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.api.config.impl;

import com.dangdang.ddframe.job.api.config.impl.AbstractJobConfiguration;
import com.dangdang.ddframe.job.api.config.impl.JobType;
import com.dangdang.ddframe.job.plugin.job.type.integrated.ScriptElasticJob;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public final class ScriptJobConfiguration
extends AbstractJobConfiguration<ScriptElasticJob> {
    private final String scriptCommandLine;

    private ScriptJobConfiguration(String jobName, int shardingTotalCount, String cron, String shardingItemParameters, String jobParameter, boolean monitorExecution, Integer maxTimeDiffSeconds, Boolean isFailover, Boolean isMisfire, Integer monitorPort, String jobShardingStrategyClass, String description, Boolean disabled, Boolean overwrite, String scriptCommandLine) {
        super(jobName, JobType.SCRIPT, ScriptElasticJob.class, shardingTotalCount, cron, shardingItemParameters, jobParameter, monitorExecution, maxTimeDiffSeconds, isFailover, isMisfire, monitorPort, jobShardingStrategyClass, description, disabled, overwrite);
        this.scriptCommandLine = scriptCommandLine;
    }

    public String getScriptCommandLine() {
        return this.scriptCommandLine;
    }

    public static class ScriptJobConfigurationBuilder
    extends AbstractJobConfiguration.AbstractJobConfigurationBuilder<ScriptJobConfiguration, ScriptElasticJob, ScriptJobConfigurationBuilder> {
        private String scriptCommandLine;

        public ScriptJobConfigurationBuilder(String jobName, int shardingTotalCount, String cron, String scriptCommandLine) {
            super(jobName, JobType.SCRIPT, ScriptElasticJob.class, shardingTotalCount, cron);
            this.scriptCommandLine = scriptCommandLine;
        }

        public ScriptJobConfigurationBuilder scriptCommandLine(String scriptCommandLine) {
            this.scriptCommandLine = scriptCommandLine;
            return this;
        }

        @Override
        protected ScriptJobConfiguration buildInternal() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.scriptCommandLine) ? 1 : 0) != 0, (Object)"script command line can not be empty.");
            return new ScriptJobConfiguration(this.getJobName(), this.getShardingTotalCount(), this.getCron(), this.getShardingItemParameters(), this.getJobParameter(), this.isMonitorExecution(), this.getMaxTimeDiffSeconds(), (Boolean)this.isFailover(), this.isMisfire(), this.getMonitorPort(), this.getJobShardingStrategyClass(), this.getDescription(), this.isDisabled(), this.isOverwrite(), this.scriptCommandLine);
        }
    }
}

