/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.config;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public class ConfigurationListenerManager
extends AbstractListenerManager {
    private final ConfigurationNode configNode;
    private final String jobName;

    public ConfigurationListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        super(coordinatorRegistryCenter, jobConfiguration);
        this.jobName = jobConfiguration.getJobName();
        this.configNode = new ConfigurationNode(this.jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new CronSettingChangedJobListener());
    }

    class CronSettingChangedJobListener
    extends AbstractJobListener {
        CronSettingChangedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (ConfigurationListenerManager.this.configNode.isCronPath(path) && TreeCacheEvent.Type.NODE_UPDATED == event.getType()) {
                String cronExpression = new String(event.getData().getData());
                JobScheduleController jobScheduler = JobRegistry.getInstance().getJobScheduleController(ConfigurationListenerManager.this.jobName);
                if (null != jobScheduler) {
                    jobScheduler.rescheduleJob(cronExpression);
                }
            }
        }
    }
}

