/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.config;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.api.config.impl.DataFlowJobConfiguration;
import com.dangdang.ddframe.job.api.config.impl.JobType;
import com.dangdang.ddframe.job.api.config.impl.ScriptJobConfiguration;
import com.dangdang.ddframe.job.exception.JobConflictException;
import com.dangdang.ddframe.job.exception.ShardingItemParametersException;
import com.dangdang.ddframe.job.exception.TimeDiffIntolerableException;
import com.dangdang.ddframe.job.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationService {
    private final JobNodeStorage jobNodeStorage;

    public ConfigurationService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobNodeStorage = new JobNodeStorage(coordinatorRegistryCenter, jobConfiguration);
    }

    public void persistJobConfiguration() {
        this.checkConflictJob();
        this.registerJobInfo();
    }

    private void checkConflictJob() {
        if (this.jobNodeStorage.isJobNodeExisted("config/jobClass")) {
            String registeredJobClassName = this.jobNodeStorage.getJobNodeData("config/jobClass");
            String toBeRegisteredJobClassName = this.jobNodeStorage.getJobConfiguration().getJobClass().getCanonicalName();
            if (!toBeRegisteredJobClassName.equals(registeredJobClassName)) {
                throw new JobConflictException(this.jobNodeStorage.getJobConfiguration().getJobName(), registeredJobClassName, toBeRegisteredJobClassName);
            }
        }
    }

    private void registerJobInfo() {
        this.fillSimpleJobInfo();
        if (JobType.DATA_FLOW == this.jobNodeStorage.getJobConfiguration().getJobType()) {
            this.fillDataFlowJobInfo();
        } else if (JobType.SCRIPT == this.jobNodeStorage.getJobConfiguration().getJobType()) {
            this.fillScriptJobInfo();
        }
    }

    private void fillSimpleJobInfo() {
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/jobType", (Object)this.jobNodeStorage.getJobConfiguration().getJobType());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/jobClass", this.jobNodeStorage.getJobConfiguration().getJobClass().getCanonicalName());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/shardingTotalCount", this.jobNodeStorage.getJobConfiguration().getShardingTotalCount());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/shardingItemParameters", this.jobNodeStorage.getJobConfiguration().getShardingItemParameters());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/jobParameter", this.jobNodeStorage.getJobConfiguration().getJobParameter());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/cron", this.jobNodeStorage.getJobConfiguration().getCron());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/monitorExecution", this.jobNodeStorage.getJobConfiguration().isMonitorExecution());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/maxTimeDiffSeconds", this.jobNodeStorage.getJobConfiguration().getMaxTimeDiffSeconds());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/failover", this.jobNodeStorage.getJobConfiguration().isFailover());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/misfire", this.jobNodeStorage.getJobConfiguration().isMisfire());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/jobShardingStrategyClass", this.jobNodeStorage.getJobConfiguration().getJobShardingStrategyClass());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/description", this.jobNodeStorage.getJobConfiguration().getDescription());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/monitorPort", this.jobNodeStorage.getJobConfiguration().getMonitorPort());
    }

    private void fillDataFlowJobInfo() {
        DataFlowJobConfiguration jobConfiguration = (DataFlowJobConfiguration)this.jobNodeStorage.getJobConfiguration();
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/processCountIntervalSeconds", jobConfiguration.getProcessCountIntervalSeconds());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/concurrentDataProcessThreadCount", jobConfiguration.getConcurrentDataProcessThreadCount());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/fetchDataCount", jobConfiguration.getFetchDataCount());
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/streamingProcess", jobConfiguration.isStreamingProcess());
    }

    private void fillScriptJobInfo() {
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite("config/scriptCommandLine", ((ScriptJobConfiguration)this.jobNodeStorage.getJobConfiguration()).getScriptCommandLine());
    }

    public JobType getJobType() {
        return this.jobNodeStorage.getJobConfiguration().getJobType();
    }

    public int getShardingTotalCount() {
        String result = this.jobNodeStorage.getJobNodeDataDirectly("config/shardingTotalCount");
        return Strings.isNullOrEmpty((String)result) ? -1 : Integer.parseInt(result);
    }

    public Map<Integer, String> getShardingItemParameters() {
        String value = this.jobNodeStorage.getJobNodeDataDirectly("config/shardingItemParameters");
        if (Strings.isNullOrEmpty((String)value)) {
            return Collections.emptyMap();
        }
        String[] shardingItemParameters = value.split(",");
        HashMap<Integer, String> result = new HashMap<Integer, String>(shardingItemParameters.length);
        for (String each : shardingItemParameters) {
            String[] pair = each.trim().split("=");
            if (2 != pair.length) {
                throw new ShardingItemParametersException("Sharding item parameters '%s' format error, should be int=xx,int=xx", value);
            }
            try {
                result.put(Integer.parseInt(pair[0].trim()), pair[1].trim());
            }
            catch (NumberFormatException ex) {
                throw new ShardingItemParametersException("Sharding item parameters key '%s' is not an integer.", pair[0]);
            }
        }
        return result;
    }

    public String getJobParameter() {
        return this.jobNodeStorage.getJobNodeDataDirectly("config/jobParameter");
    }

    public String getCron() {
        return this.jobNodeStorage.getJobNodeDataDirectly("config/cron");
    }

    public boolean isMonitorExecution() {
        return Boolean.valueOf(this.jobNodeStorage.getJobNodeData("config/monitorExecution"));
    }

    public int getProcessCountIntervalSeconds() {
        return Integer.parseInt(this.jobNodeStorage.getJobNodeData("config/processCountIntervalSeconds"));
    }

    public int getConcurrentDataProcessThreadCount() {
        return Integer.parseInt(this.jobNodeStorage.getJobNodeData("config/concurrentDataProcessThreadCount"));
    }

    public int getFetchDataCount() {
        return Integer.parseInt(this.jobNodeStorage.getJobNodeData("config/fetchDataCount"));
    }

    public boolean isStreamingProcess() {
        return Boolean.valueOf(this.jobNodeStorage.getJobNodeData("config/streamingProcess"));
    }

    public void checkMaxTimeDiffSecondsTolerable() {
        int maxTimeDiffSeconds = Integer.parseInt(this.jobNodeStorage.getJobNodeData("config/maxTimeDiffSeconds"));
        if (-1 == maxTimeDiffSeconds) {
            return;
        }
        long timeDiff = Math.abs(System.currentTimeMillis() - this.jobNodeStorage.getRegistryCenterTime());
        if (timeDiff > (long)maxTimeDiffSeconds * 1000L) {
            throw new TimeDiffIntolerableException(Long.valueOf(timeDiff / 1000L).intValue(), maxTimeDiffSeconds);
        }
    }

    public boolean isFailover() {
        return this.isMonitorExecution() && Boolean.valueOf(this.jobNodeStorage.getJobNodeData("config/failover")) != false;
    }

    public boolean isMisfire() {
        return Boolean.valueOf(this.jobNodeStorage.getJobNodeData("config/misfire"));
    }

    public String getJobShardingStrategyClass() {
        return this.jobNodeStorage.getJobNodeData("config/jobShardingStrategyClass");
    }

    public int getMonitorPort() {
        return Integer.valueOf(this.jobNodeStorage.getJobNodeData("config/monitorPort"));
    }

    public String getJobName() {
        return this.jobNodeStorage.getJobConfiguration().getJobName();
    }

    public String getScriptCommandLine() {
        return this.jobNodeStorage.getJobNodeData("config/scriptCommandLine");
    }
}

