/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.election;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.internal.election.ElectionNode;
import com.dangdang.ddframe.job.internal.election.LeaderElectionService;
import com.dangdang.ddframe.job.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.internal.server.ServerNode;
import com.dangdang.ddframe.job.internal.server.ServerService;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.beans.ConstructorProperties;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectionListenerManager
extends AbstractListenerManager {
    private static final Logger log = LoggerFactory.getLogger(ElectionListenerManager.class);
    private final LeaderElectionService leaderElectionService;
    private final ServerService serverService;
    private final ElectionNode electionNode;
    private final ServerNode serverNode;

    public ElectionListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        super(coordinatorRegistryCenter, jobConfiguration);
        this.leaderElectionService = new LeaderElectionService(coordinatorRegistryCenter, jobConfiguration);
        this.serverService = new ServerService(coordinatorRegistryCenter, jobConfiguration);
        this.electionNode = new ElectionNode(jobConfiguration.getJobName());
        this.serverNode = new ServerNode(jobConfiguration.getJobName());
    }

    @Override
    public void start() {
        this.addDataListener(new LeaderElectionJobListener());
    }

    class LeaderElectionJobListener
    extends AbstractJobListener {
        LeaderElectionJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            EventHelper eventHelper = new EventHelper(path, event);
            if (eventHelper.isLeaderCrashedOrServerOn() && !ElectionListenerManager.this.leaderElectionService.hasLeader() && !ElectionListenerManager.this.serverService.getAvailableServers().isEmpty()) {
                log.debug("Elastic job: leader crashed, elect a new leader now.");
                ElectionListenerManager.this.leaderElectionService.leaderElection();
                log.debug("Elastic job: leader election completed.");
                return;
            }
            if (eventHelper.isServerOff() && ElectionListenerManager.this.leaderElectionService.isLeader().booleanValue()) {
                ElectionListenerManager.this.leaderElectionService.removeLeader();
            }
        }

        final class EventHelper {
            private final String path;
            private final TreeCacheEvent event;

            boolean isLeaderCrashedOrServerOn() {
                return this.isLeaderCrashed() || this.isServerEnabled() || this.isServerResumed();
            }

            private boolean isLeaderCrashed() {
                return ElectionListenerManager.this.electionNode.isLeaderHostPath(this.path) && TreeCacheEvent.Type.NODE_REMOVED == this.event.getType();
            }

            private boolean isServerEnabled() {
                return ElectionListenerManager.this.serverNode.isLocalServerDisabledPath(this.path) && TreeCacheEvent.Type.NODE_REMOVED == this.event.getType();
            }

            private boolean isServerResumed() {
                return ElectionListenerManager.this.serverNode.isLocalJobPausedPath(this.path) && TreeCacheEvent.Type.NODE_REMOVED == this.event.getType();
            }

            boolean isServerOff() {
                return this.isServerDisabled() || this.isServerPaused() || this.isServerShutdown();
            }

            private boolean isServerDisabled() {
                return ElectionListenerManager.this.serverNode.isLocalServerDisabledPath(this.path) && TreeCacheEvent.Type.NODE_ADDED == this.event.getType();
            }

            private boolean isServerPaused() {
                return ElectionListenerManager.this.serverNode.isLocalJobPausedPath(this.path) && TreeCacheEvent.Type.NODE_ADDED == this.event.getType();
            }

            private boolean isServerShutdown() {
                return ElectionListenerManager.this.serverNode.isLocalJobShutdownPath(this.path) && TreeCacheEvent.Type.NODE_ADDED == this.event.getType();
            }

            @ConstructorProperties(value={"path", "event"})
            public EventHelper(String path, TreeCacheEvent event) {
                this.path = path;
                this.event = event;
            }
        }
    }
}

