/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.execution;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.internal.election.LeaderElectionService;
import com.dangdang.ddframe.job.internal.execution.ExecutionNode;
import com.dangdang.ddframe.job.internal.reg.BlockUtils;
import com.dangdang.ddframe.job.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.internal.server.ServerService;
import com.dangdang.ddframe.job.internal.server.ServerStatus;
import com.dangdang.ddframe.job.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ExecutionService {
    private final JobConfiguration jobConfiguration;
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;
    private final ServerService serverService;
    private final LeaderElectionService leaderElectionService;

    public ExecutionService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
        this.jobNodeStorage = new JobNodeStorage(coordinatorRegistryCenter, jobConfiguration);
        this.configService = new ConfigurationService(coordinatorRegistryCenter, jobConfiguration);
        this.serverService = new ServerService(coordinatorRegistryCenter, jobConfiguration);
        this.leaderElectionService = new LeaderElectionService(coordinatorRegistryCenter, jobConfiguration);
    }

    public void registerJobBegin(JobExecutionMultipleShardingContext jobExecutionShardingContext) {
        if (!jobExecutionShardingContext.getShardingItems().isEmpty() && this.configService.isMonitorExecution()) {
            this.serverService.updateServerStatus(ServerStatus.RUNNING);
            for (int each : jobExecutionShardingContext.getShardingItems()) {
                Date nextFireTime;
                this.jobNodeStorage.fillEphemeralJobNode(ExecutionNode.getRunningNode(each), "");
                this.jobNodeStorage.replaceJobNode(ExecutionNode.getLastBeginTimeNode(each), System.currentTimeMillis());
                JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(this.jobConfiguration.getJobName());
                if (null == jobScheduleController || null == (nextFireTime = jobScheduleController.getNextFireTime())) continue;
                this.jobNodeStorage.replaceJobNode(ExecutionNode.getNextFireTimeNode(each), nextFireTime.getTime());
            }
        }
    }

    public void cleanPreviousExecutionInfo() {
        if (!this.jobNodeStorage.isJobNodeExisted("execution")) {
            return;
        }
        if (this.leaderElectionService.isLeader().booleanValue()) {
            this.jobNodeStorage.fillEphemeralJobNode("leader/execution/cleaning", "");
            List<Integer> items = this.getAllItems();
            for (int each : items) {
                this.jobNodeStorage.removeJobNodeIfExisted(ExecutionNode.getCompletedNode(each));
            }
            if (this.jobNodeStorage.isJobNodeExisted("leader/execution/necessary")) {
                this.fixExecutionInfo(items);
            }
            this.jobNodeStorage.removeJobNodeIfExisted("leader/execution/cleaning");
        }
        while (this.jobNodeStorage.isJobNodeExisted("leader/execution/cleaning")) {
            BlockUtils.waitingShortTime();
        }
    }

    private void fixExecutionInfo(List<Integer> items) {
        int currentShardingTotalCount;
        int newShardingTotalCount = this.configService.getShardingTotalCount();
        if (newShardingTotalCount > (currentShardingTotalCount = items.size())) {
            for (int i = currentShardingTotalCount; i < newShardingTotalCount; ++i) {
                this.jobNodeStorage.createJobNodeIfNeeded("execution/" + i);
            }
        } else if (newShardingTotalCount < currentShardingTotalCount) {
            for (int i = newShardingTotalCount; i < currentShardingTotalCount; ++i) {
                this.jobNodeStorage.removeJobNodeIfExisted("execution/" + i);
            }
        }
        this.jobNodeStorage.removeJobNodeIfExisted("leader/execution/necessary");
    }

    public void registerJobCompleted(JobExecutionMultipleShardingContext jobExecutionShardingContext) {
        if (!this.configService.isMonitorExecution()) {
            return;
        }
        this.serverService.updateServerStatus(ServerStatus.READY);
        for (int each : jobExecutionShardingContext.getShardingItems()) {
            this.jobNodeStorage.createJobNodeIfNeeded(ExecutionNode.getCompletedNode(each));
            this.jobNodeStorage.removeJobNodeIfExisted(ExecutionNode.getRunningNode(each));
            this.jobNodeStorage.replaceJobNode(ExecutionNode.getLastCompleteTimeNode(each), System.currentTimeMillis());
        }
    }

    public void setNeedFixExecutionInfoFlag() {
        this.jobNodeStorage.createJobNodeIfNeeded("leader/execution/necessary");
    }

    public void clearRunningInfo(List<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ExecutionNode.getRunningNode(each));
        }
    }

    public boolean misfireIfNecessary(List<Integer> items) {
        if (this.hasRunningItems(items)) {
            this.setMisfire(items);
            return true;
        }
        return false;
    }

    public void setMisfire(List<Integer> items) {
        if (!this.configService.isMonitorExecution()) {
            return;
        }
        for (int each : items) {
            this.jobNodeStorage.createJobNodeIfNeeded(ExecutionNode.getMisfireNode(each));
        }
    }

    public List<Integer> getMisfiredJobItems(List<Integer> items) {
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ExecutionNode.getMisfireNode(each))) continue;
            result.add(each);
        }
        return result;
    }

    public void clearMisfire(List<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(ExecutionNode.getMisfireNode(each));
        }
    }

    public void removeExecutionInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("execution");
    }

    public boolean isCompleted(int item) {
        return this.jobNodeStorage.isJobNodeExisted(ExecutionNode.getCompletedNode(item));
    }

    public boolean hasRunningItems(List<Integer> items) {
        if (!this.configService.isMonitorExecution()) {
            return false;
        }
        for (int each : items) {
            if (!this.jobNodeStorage.isJobNodeExisted(ExecutionNode.getRunningNode(each))) continue;
            return true;
        }
        return false;
    }

    public boolean hasRunningItems() {
        return this.hasRunningItems(this.getAllItems());
    }

    private List<Integer> getAllItems() {
        return Lists.transform(this.jobNodeStorage.getJobNodeChildrenKeys("execution"), (Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return Integer.parseInt(input);
            }
        });
    }
}

