/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.executor;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.api.listener.AbstractDistributeOnceElasticJobListener;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.exception.JobException;
import com.dangdang.ddframe.job.internal.guarantee.GuaranteeService;
import com.dangdang.ddframe.job.internal.schedule.JobFacade;
import com.dangdang.ddframe.job.internal.schedule.SchedulerFacade;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecutor {
    private static final Logger log = LoggerFactory.getLogger(JobExecutor.class);
    private final String jobName;
    private final CoordinatorRegistryCenter regCenter;
    private final ElasticJob elasticJob;
    private final SchedulerFacade schedulerFacade;

    public JobExecutor(CoordinatorRegistryCenter regCenter, JobConfiguration jobConfig, ElasticJobListener ... elasticJobListeners) {
        this.jobName = jobConfig.getJobName();
        this.regCenter = regCenter;
        List<ElasticJobListener> elasticJobListenerList = Arrays.asList(elasticJobListeners);
        this.setGuaranteeServiceForElasticJobListeners(regCenter, jobConfig, elasticJobListenerList);
        this.elasticJob = this.createElasticJob(jobConfig, elasticJobListenerList);
        this.schedulerFacade = new SchedulerFacade(regCenter, jobConfig, elasticJobListenerList);
    }

    private void setGuaranteeServiceForElasticJobListeners(CoordinatorRegistryCenter regCenter, JobConfiguration jobConfig, List<ElasticJobListener> elasticJobListeners) {
        GuaranteeService guaranteeService = new GuaranteeService(regCenter, jobConfig);
        for (ElasticJobListener each : elasticJobListeners) {
            if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
            ((AbstractDistributeOnceElasticJobListener)each).setGuaranteeService(guaranteeService);
        }
    }

    private ElasticJob createElasticJob(JobConfiguration jobConfig, List<ElasticJobListener> elasticJobListenerList) {
        ElasticJob result;
        try {
            result = (ElasticJob)jobConfig.getJobClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new JobException(ex);
        }
        result.setJobFacade(new JobFacade(this.regCenter, jobConfig, elasticJobListenerList));
        return result;
    }

    public void init() {
        log.debug("Elastic job: job controller init, job name is: {}.", (Object)this.jobName);
        this.schedulerFacade.clearPreviousServerStatus();
        this.regCenter.addCacheData("/" + this.jobName);
        this.schedulerFacade.registerStartUpInfo();
    }

    public String getJobName() {
        return this.jobName;
    }

    public CoordinatorRegistryCenter getRegCenter() {
        return this.regCenter;
    }

    public ElasticJob getElasticJob() {
        return this.elasticJob;
    }

    public SchedulerFacade getSchedulerFacade() {
        return this.schedulerFacade;
    }
}

