/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.failover;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.internal.execution.ExecutionNode;
import com.dangdang.ddframe.job.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.internal.failover.FailoverNode;
import com.dangdang.ddframe.job.internal.failover.FailoverService;
import com.dangdang.ddframe.job.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.internal.sharding.ShardingService;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public class FailoverListenerManager
extends AbstractListenerManager {
    private final ConfigurationService configService;
    private final ExecutionService executionService;
    private final ShardingService shardingService;
    private final FailoverService failoverService;
    private final ConfigurationNode configNode;
    private final ExecutionNode executionNode;
    private final FailoverNode failoverNode;

    public FailoverListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        super(coordinatorRegistryCenter, jobConfiguration);
        this.configService = new ConfigurationService(coordinatorRegistryCenter, jobConfiguration);
        this.executionService = new ExecutionService(coordinatorRegistryCenter, jobConfiguration);
        this.shardingService = new ShardingService(coordinatorRegistryCenter, jobConfiguration);
        this.failoverService = new FailoverService(coordinatorRegistryCenter, jobConfiguration);
        this.configNode = new ConfigurationNode(jobConfiguration.getJobName());
        this.executionNode = new ExecutionNode(jobConfiguration.getJobName());
        this.failoverNode = new FailoverNode(jobConfiguration.getJobName());
    }

    @Override
    public void start() {
        this.addDataListener(new JobCrashedJobListener());
        this.addDataListener(new FailoverJobCrashedJobListener());
        this.addDataListener(new FailoverSettingsChangedJobListener());
    }

    private void failover(Integer item, TreeCacheEvent event) {
        if (!this.isJobCrashAndNeedFailover(item, event)) {
            return;
        }
        this.failoverService.setCrashedFailoverFlag(item);
        if (!this.executionService.hasRunningItems(this.shardingService.getLocalHostShardingItems())) {
            this.failoverService.failoverIfNecessary();
        }
    }

    private boolean isJobCrashAndNeedFailover(Integer item, TreeCacheEvent event) {
        return null != item && TreeCacheEvent.Type.NODE_REMOVED == event.getType() && !this.executionService.isCompleted(item) && this.configService.isFailover();
    }

    class FailoverSettingsChangedJobListener
    extends AbstractJobListener {
        FailoverSettingsChangedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (FailoverListenerManager.this.configNode.isFailoverPath(path) && TreeCacheEvent.Type.NODE_UPDATED == event.getType() && !Boolean.valueOf(new String(event.getData().getData())).booleanValue()) {
                FailoverListenerManager.this.failoverService.removeFailoverInfo();
            }
        }
    }

    class FailoverJobCrashedJobListener
    extends AbstractJobListener {
        FailoverJobCrashedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            FailoverListenerManager.this.failover(FailoverListenerManager.this.failoverNode.getItemByExecutionFailoverPath(path), event);
        }
    }

    class JobCrashedJobListener
    extends AbstractJobListener {
        JobCrashedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            FailoverListenerManager.this.failover(FailoverListenerManager.this.executionNode.getItemByRunningItemPath(path), event);
        }
    }
}

