/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.guarantee;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.api.listener.AbstractDistributeOnceElasticJobListener;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.internal.guarantee.GuaranteeNode;
import com.dangdang.ddframe.job.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public class GuaranteeListenerManager
extends AbstractListenerManager {
    private final GuaranteeNode guaranteeNode;
    private final List<ElasticJobListener> elasticJobListeners;

    public GuaranteeListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration, List<ElasticJobListener> elasticJobListeners) {
        super(coordinatorRegistryCenter, jobConfiguration);
        this.guaranteeNode = new GuaranteeNode(jobConfiguration.getJobName());
        this.elasticJobListeners = elasticJobListeners;
    }

    @Override
    public void start() {
        this.addDataListener(new StartedNodeRemovedJobListener());
        this.addDataListener(new CompletedNodeRemovedJobListener());
    }

    class CompletedNodeRemovedJobListener
    extends AbstractJobListener {
        CompletedNodeRemovedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (TreeCacheEvent.Type.NODE_REMOVED == event.getType() && GuaranteeListenerManager.this.guaranteeNode.isCompletedRootNode(path)) {
                for (ElasticJobListener each : GuaranteeListenerManager.this.elasticJobListeners) {
                    if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
                    ((AbstractDistributeOnceElasticJobListener)each).notifyWaitingTaskComplete();
                }
            }
        }
    }

    class StartedNodeRemovedJobListener
    extends AbstractJobListener {
        StartedNodeRemovedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (TreeCacheEvent.Type.NODE_REMOVED == event.getType() && GuaranteeListenerManager.this.guaranteeNode.isStartedRootNode(path)) {
                for (ElasticJobListener each : GuaranteeListenerManager.this.elasticJobListeners) {
                    if (!(each instanceof AbstractDistributeOnceElasticJobListener)) continue;
                    ((AbstractDistributeOnceElasticJobListener)each).notifyWaitingTaskStart();
                }
            }
        }
    }
}

