/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.guarantee;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.internal.guarantee.GuaranteeNode;
import com.dangdang.ddframe.job.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.Collection;

public class GuaranteeService {
    private final JobNodeStorage jobNodeStorage;
    private final ConfigurationService configService;

    public GuaranteeService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobNodeStorage = new JobNodeStorage(coordinatorRegistryCenter, jobConfiguration);
        this.configService = new ConfigurationService(coordinatorRegistryCenter, jobConfiguration);
    }

    public void registerStart(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getStartedNode(each));
        }
    }

    public boolean isAllStarted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/started") && this.configService.getShardingTotalCount() == this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/started").size();
    }

    public void clearAllStartedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/started");
    }

    public void registerComplete(Collection<Integer> shardingItems) {
        for (int each : shardingItems) {
            this.jobNodeStorage.createJobNodeIfNeeded(GuaranteeNode.getCompletedNode(each));
        }
    }

    public boolean isAllCompleted() {
        return this.jobNodeStorage.isJobNodeExisted("guarantee/completed") && this.configService.getShardingTotalCount() <= this.jobNodeStorage.getJobNodeChildrenKeys("guarantee/completed").size();
    }

    public void clearAllCompletedInfo() {
        this.jobNodeStorage.removeJobNodeIfExisted("guarantee/completed");
    }
}

