/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.job;

import com.dangdang.ddframe.job.api.ElasticJob;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.exception.JobException;
import com.dangdang.ddframe.job.internal.schedule.JobFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElasticJob
implements ElasticJob {
    private static final Logger log = LoggerFactory.getLogger(AbstractElasticJob.class);
    private JobFacade jobFacade;

    @Override
    public final void execute() {
        log.trace("Elastic job: job execute begin.");
        this.jobFacade.checkMaxTimeDiffSecondsTolerable();
        JobExecutionMultipleShardingContext shardingContext = this.jobFacade.getShardingContext();
        if (this.jobFacade.misfireIfNecessary(shardingContext.getShardingItems())) {
            log.debug("Elastic job: previous job is still running, new job will start after previous job completed. Misfired job had recorded.");
            return;
        }
        this.jobFacade.cleanPreviousExecutionInfo();
        try {
            this.jobFacade.beforeJobExecuted(shardingContext);
        }
        catch (Throwable cause) {
            this.handleJobExecutionException(new JobException(cause));
        }
        this.executeJobInternal(shardingContext);
        log.trace("Elastic job: execute normal completed, sharding context:{}.", (Object)shardingContext);
        while (this.jobFacade.isExecuteMisfired(shardingContext.getShardingItems())) {
            log.trace("Elastic job: execute misfired job, sharding context:{}.", (Object)shardingContext);
            this.jobFacade.clearMisfire(shardingContext.getShardingItems());
            this.executeJobInternal(shardingContext);
            log.trace("Elastic job: misfired job completed, sharding context:{}.", (Object)shardingContext);
        }
        this.jobFacade.failoverIfNecessary();
        try {
            this.jobFacade.afterJobExecuted(shardingContext);
        }
        catch (Throwable cause) {
            this.handleJobExecutionException(new JobException(cause));
        }
        log.trace("Elastic job: execute all completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJobInternal(JobExecutionMultipleShardingContext shardingContext) {
        if (shardingContext.getShardingItems().isEmpty()) {
            log.trace("Elastic job: sharding item is empty, job execution context:{}.", (Object)shardingContext);
            return;
        }
        this.jobFacade.registerJobBegin(shardingContext);
        try {
            this.executeJob(shardingContext);
        }
        catch (Throwable cause) {
            this.handleJobExecutionException(new JobException(cause));
        }
        finally {
            this.jobFacade.registerJobCompleted(shardingContext);
        }
    }

    protected abstract void executeJob(JobExecutionMultipleShardingContext var1);

    @Override
    public void handleJobExecutionException(JobException jobException) {
        log.error("Elastic job: exception occur in job processing...", jobException.getCause());
    }

    @Override
    public final JobFacade getJobFacade() {
        return this.jobFacade;
    }

    @Override
    public final void setJobFacade(JobFacade jobFacade) {
        this.jobFacade = jobFacade;
    }
}

