/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.schedule;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.api.config.impl.JobType;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.internal.election.LeaderElectionService;
import com.dangdang.ddframe.job.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.internal.listener.ListenerManager;
import com.dangdang.ddframe.job.internal.monitor.MonitorService;
import com.dangdang.ddframe.job.internal.schedule.JobTriggerListener;
import com.dangdang.ddframe.job.internal.server.ServerService;
import com.dangdang.ddframe.job.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.internal.statistics.StatisticsService;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.List;

public class SchedulerFacade {
    private final ConfigurationService configService;
    private final LeaderElectionService leaderElectionService;
    private final ServerService serverService;
    private final ShardingService shardingService;
    private final ExecutionService executionService;
    private final StatisticsService statisticsService;
    private final MonitorService monitorService;
    private final ListenerManager listenerManager;

    public SchedulerFacade(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration, List<ElasticJobListener> elasticJobListeners) {
        this.configService = new ConfigurationService(coordinatorRegistryCenter, jobConfiguration);
        this.leaderElectionService = new LeaderElectionService(coordinatorRegistryCenter, jobConfiguration);
        this.serverService = new ServerService(coordinatorRegistryCenter, jobConfiguration);
        this.shardingService = new ShardingService(coordinatorRegistryCenter, jobConfiguration);
        this.executionService = new ExecutionService(coordinatorRegistryCenter, jobConfiguration);
        this.statisticsService = new StatisticsService(coordinatorRegistryCenter, jobConfiguration);
        this.monitorService = new MonitorService(coordinatorRegistryCenter, jobConfiguration);
        this.listenerManager = new ListenerManager(coordinatorRegistryCenter, jobConfiguration, elasticJobListeners);
    }

    public void clearPreviousServerStatus() {
        this.serverService.clearPreviousServerStatus();
    }

    public void registerStartUpInfo() {
        this.listenerManager.startAllListeners();
        this.leaderElectionService.leaderForceElection();
        this.configService.persistJobConfiguration();
        this.serverService.persistServerOnline();
        this.serverService.clearJobPausedStatus();
        if (JobType.DATA_FLOW == this.configService.getJobType()) {
            this.statisticsService.startProcessCountJob();
        }
        this.shardingService.setReshardingFlag();
        this.monitorService.listen();
    }

    public void releaseJobResource() {
        this.monitorService.close();
        if (JobType.DATA_FLOW.equals((Object)this.configService.getJobType())) {
            this.statisticsService.stopProcessCountJob();
        }
        this.serverService.removeServerStatus();
    }

    public String getCron() {
        return this.configService.getCron();
    }

    public boolean isMisfire() {
        return this.configService.isMisfire();
    }

    public JobTriggerListener newJobTriggerListener() {
        return new JobTriggerListener(this.executionService, this.shardingService);
    }
}

