/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.server;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.internal.election.LeaderElectionService;
import com.dangdang.ddframe.job.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.internal.server.ServerNode;
import com.dangdang.ddframe.job.internal.server.ServerService;
import com.dangdang.ddframe.job.internal.sharding.ShardingService;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;

public class JobOperationListenerManager
extends AbstractListenerManager {
    private final String jobName;
    private final ServerNode serverNode;
    private final LeaderElectionService leaderElectionService;
    private final ServerService serverService;
    private final ShardingService shardingService;
    private final ExecutionService executionService;

    public JobOperationListenerManager(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        super(coordinatorRegistryCenter, jobConfiguration);
        this.jobName = jobConfiguration.getJobName();
        this.serverNode = new ServerNode(this.jobName);
        this.leaderElectionService = new LeaderElectionService(coordinatorRegistryCenter, jobConfiguration);
        this.serverService = new ServerService(coordinatorRegistryCenter, jobConfiguration);
        this.shardingService = new ShardingService(coordinatorRegistryCenter, jobConfiguration);
        this.executionService = new ExecutionService(coordinatorRegistryCenter, jobConfiguration);
    }

    @Override
    public void start() {
        this.addConnectionStateListener(new ConnectionLostListener());
        this.addDataListener(new JobTriggerStatusJobListener());
        this.addDataListener(new JobPausedStatusJobListener());
        this.addDataListener(new JobShutdownStatusJobListener());
    }

    class JobShutdownStatusJobListener
    extends AbstractJobListener {
        JobShutdownStatusJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (!JobOperationListenerManager.this.serverNode.isLocalJobShutdownPath(path)) {
                return;
            }
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(JobOperationListenerManager.this.jobName);
            if (null != jobScheduleController && TreeCacheEvent.Type.NODE_ADDED == event.getType()) {
                jobScheduleController.shutdown();
                JobOperationListenerManager.this.serverService.processServerShutdown();
            }
        }
    }

    class JobPausedStatusJobListener
    extends AbstractJobListener {
        JobPausedStatusJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (!JobOperationListenerManager.this.serverNode.isLocalJobPausedPath(path)) {
                return;
            }
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(JobOperationListenerManager.this.jobName);
            if (null == jobScheduleController) {
                return;
            }
            if (TreeCacheEvent.Type.NODE_ADDED == event.getType()) {
                jobScheduleController.pauseJob();
            }
            if (TreeCacheEvent.Type.NODE_REMOVED == event.getType()) {
                jobScheduleController.resumeJob();
                JobOperationListenerManager.this.serverService.clearJobPausedStatus();
            }
        }
    }

    class JobTriggerStatusJobListener
    extends AbstractJobListener {
        JobTriggerStatusJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (TreeCacheEvent.Type.NODE_ADDED != event.getType() || !JobOperationListenerManager.this.serverNode.isLocalJobTriggerPath(path)) {
                return;
            }
            JobOperationListenerManager.this.serverService.clearJobTriggerStatus();
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(JobOperationListenerManager.this.jobName);
            if (null == jobScheduleController) {
                return;
            }
            if (JobOperationListenerManager.this.serverService.isLocalhostServerReady()) {
                jobScheduleController.triggerJob();
            }
        }
    }

    class ConnectionLostListener
    implements ConnectionStateListener {
        ConnectionLostListener() {
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(JobOperationListenerManager.this.jobName);
            if (ConnectionState.LOST == newState) {
                jobScheduleController.pauseJob();
            } else if (ConnectionState.RECONNECTED == newState) {
                if (!JobOperationListenerManager.this.leaderElectionService.hasLeader()) {
                    JobOperationListenerManager.this.leaderElectionService.leaderElection();
                }
                JobOperationListenerManager.this.serverService.persistServerOnline();
                JobOperationListenerManager.this.executionService.clearRunningInfo(JobOperationListenerManager.this.shardingService.getLocalHostShardingItems());
                if (!JobOperationListenerManager.this.serverService.isJobPausedManually()) {
                    jobScheduleController.resumeJob();
                }
            }
        }
    }
}

