/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.server;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.internal.env.LocalHostService;
import com.dangdang.ddframe.job.internal.server.ServerNode;
import com.dangdang.ddframe.job.internal.server.ServerStatus;
import com.dangdang.ddframe.job.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServerService {
    private final JobNodeStorage jobNodeStorage;
    private final LocalHostService localHostService = new LocalHostService();

    public ServerService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobNodeStorage = new JobNodeStorage(coordinatorRegistryCenter, jobConfiguration);
    }

    public void clearPreviousServerStatus() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getStatusNode(this.localHostService.getIp()));
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getShutdownNode(this.localHostService.getIp()));
    }

    public void persistServerOnline() {
        this.jobNodeStorage.fillJobNodeIfNullOrOverwrite(ServerNode.getHostNameNode(this.localHostService.getIp()), this.localHostService.getHostName());
        this.persistDisabled();
        this.jobNodeStorage.fillEphemeralJobNode(ServerNode.getStatusNode(this.localHostService.getIp()), (Object)ServerStatus.READY);
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getShutdownNode(this.localHostService.getIp()));
    }

    private void persistDisabled() {
        if (!this.jobNodeStorage.getJobConfiguration().isOverwrite()) {
            return;
        }
        if (this.jobNodeStorage.getJobConfiguration().isDisabled()) {
            this.jobNodeStorage.fillJobNodeIfNullOrOverwrite(ServerNode.getDisabledNode(this.localHostService.getIp()), "");
        } else {
            this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getDisabledNode(this.localHostService.getIp()));
        }
    }

    public void clearJobTriggerStatus() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getTriggerNode(this.localHostService.getIp()));
    }

    public void clearJobPausedStatus() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getPausedNode(this.localHostService.getIp()));
    }

    public boolean isJobPausedManually() {
        return this.jobNodeStorage.isJobNodeExisted(ServerNode.getPausedNode(this.localHostService.getIp()));
    }

    public void processServerShutdown() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getStatusNode(this.localHostService.getIp()));
    }

    public void updateServerStatus(ServerStatus status) {
        this.jobNodeStorage.updateJobNode(ServerNode.getStatusNode(this.localHostService.getIp()), (Object)status);
    }

    public void removeServerStatus() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getStatusNode(this.localHostService.getIp()));
    }

    public List<String> getAllServers() {
        List<String> result = this.jobNodeStorage.getJobNodeChildrenKeys("servers");
        Collections.sort(result);
        return result;
    }

    public List<String> getAvailableServers() {
        List<String> servers = this.getAllServers();
        ArrayList<String> result = new ArrayList<String>(servers.size());
        for (String each : servers) {
            if (!this.isAvailableServer(each)) continue;
            result.add(each);
        }
        return result;
    }

    public boolean isAvailableServer(String ip) {
        return this.jobNodeStorage.isJobNodeExisted(ServerNode.getStatusNode(ip)) && !this.jobNodeStorage.isJobNodeExisted(ServerNode.getPausedNode(ip)) && !this.jobNodeStorage.isJobNodeExisted(ServerNode.getDisabledNode(ip)) && !this.jobNodeStorage.isJobNodeExisted(ServerNode.getShutdownNode(ip));
    }

    public boolean isLocalhostServerReady() {
        String ip = this.localHostService.getIp();
        return this.isAvailableServer(ip) && ServerStatus.READY.name().equals(this.jobNodeStorage.getJobNodeData(ServerNode.getStatusNode(ip)));
    }

    public void persistProcessSuccessCount(int processSuccessCount) {
        this.jobNodeStorage.replaceJobNode(ServerNode.getProcessSuccessCountNode(this.localHostService.getIp()), processSuccessCount);
    }

    public void persistProcessFailureCount(int processFailureCount) {
        this.jobNodeStorage.replaceJobNode(ServerNode.getProcessFailureCountNode(this.localHostService.getIp()), processFailureCount);
    }
}

