/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.statistics;

import com.dangdang.ddframe.job.api.config.JobConfiguration;
import com.dangdang.ddframe.job.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.internal.statistics.ProcessCountJob;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StatisticsService {
    private final CoordinatorRegistryCenter coordinatorRegistryCenter;
    private final JobConfiguration jobConfiguration;
    private final ConfigurationService configService;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public StatisticsService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.coordinatorRegistryCenter = coordinatorRegistryCenter;
        this.jobConfiguration = jobConfiguration;
        this.configService = new ConfigurationService(coordinatorRegistryCenter, jobConfiguration);
    }

    public void startProcessCountJob() {
        int processCountIntervalSeconds = this.configService.getProcessCountIntervalSeconds();
        if (processCountIntervalSeconds > 0) {
            this.scheduledExecutorService.scheduleAtFixedRate(new ProcessCountJob(this.coordinatorRegistryCenter, this.jobConfiguration), processCountIntervalSeconds, processCountIntervalSeconds, TimeUnit.SECONDS);
        }
    }

    public void stopProcessCountJob() {
        this.scheduledExecutorService.shutdown();
    }
}

