/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.reg.zookeeper;

import com.dangdang.ddframe.reg.base.AbstractRegistryCenterConfiguration;
import com.google.common.base.Strings;

public class ZookeeperConfiguration
extends AbstractRegistryCenterConfiguration {
    private String serverLists;
    private String namespace;
    private int baseSleepTimeMilliseconds = 1000;
    private int maxSleepTimeMilliseconds = 3000;
    private int maxRetries = 3;
    private int sessionTimeoutMilliseconds;
    private int connectionTimeoutMilliseconds;
    private String digest;
    private int nestedPort = -1;
    private String nestedDataDir;

    public ZookeeperConfiguration(String serverLists, String namespace) {
        this.serverLists = serverLists;
        this.namespace = namespace;
    }

    public ZookeeperConfiguration(String serverLists, String namespace, int baseSleepTimeMilliseconds, int maxSleepTimeMilliseconds, int maxRetries) {
        this.serverLists = serverLists;
        this.namespace = namespace;
        this.baseSleepTimeMilliseconds = baseSleepTimeMilliseconds;
        this.maxSleepTimeMilliseconds = maxSleepTimeMilliseconds;
        this.maxRetries = maxRetries;
    }

    public boolean isUseNestedZookeeper() {
        return -1 != this.nestedPort && !Strings.isNullOrEmpty((String)this.nestedDataDir);
    }

    public String getServerLists() {
        return this.serverLists;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getBaseSleepTimeMilliseconds() {
        return this.baseSleepTimeMilliseconds;
    }

    public int getMaxSleepTimeMilliseconds() {
        return this.maxSleepTimeMilliseconds;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getSessionTimeoutMilliseconds() {
        return this.sessionTimeoutMilliseconds;
    }

    public int getConnectionTimeoutMilliseconds() {
        return this.connectionTimeoutMilliseconds;
    }

    public String getDigest() {
        return this.digest;
    }

    public int getNestedPort() {
        return this.nestedPort;
    }

    public String getNestedDataDir() {
        return this.nestedDataDir;
    }

    public void setServerLists(String serverLists) {
        this.serverLists = serverLists;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBaseSleepTimeMilliseconds(int baseSleepTimeMilliseconds) {
        this.baseSleepTimeMilliseconds = baseSleepTimeMilliseconds;
    }

    public void setMaxSleepTimeMilliseconds(int maxSleepTimeMilliseconds) {
        this.maxSleepTimeMilliseconds = maxSleepTimeMilliseconds;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setSessionTimeoutMilliseconds(int sessionTimeoutMilliseconds) {
        this.sessionTimeoutMilliseconds = sessionTimeoutMilliseconds;
    }

    public void setConnectionTimeoutMilliseconds(int connectionTimeoutMilliseconds) {
        this.connectionTimeoutMilliseconds = connectionTimeoutMilliseconds;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void setNestedPort(int nestedPort) {
        this.nestedPort = nestedPort;
    }

    public void setNestedDataDir(String nestedDataDir) {
        this.nestedDataDir = nestedDataDir;
    }

    public ZookeeperConfiguration() {
    }
}

