/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript.compress;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.codehaus.mojo.javascript.compress.CompressionException;
import org.codehaus.mojo.javascript.compress.JSCompressor;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YahooUICompressor
implements JSCompressor {
    public void compress(File input, File compressed, int level, int language) throws CompressionException {
        FileWriter out = null;
        try {
            JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)new FileReader(input), new ErrorReporter(){

                public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    if (line < 0) {
                        System.err.println("\n[WARNING] " + message);
                    } else {
                        System.err.println("\n" + line + ':' + lineOffset + ':' + message);
                    }
                }

                public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    if (line < 0) {
                        System.err.println("\n[ERROR] " + message);
                    } else {
                        System.err.println("\n" + line + ':' + lineOffset + ':' + message);
                    }
                }

                public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                    this.error(message, sourceName, line, lineSource, lineOffset);
                    return new EvaluatorException(message);
                }
            });
            int linebreakpos = level < 4 ? -1 : 80;
            boolean munge = level < 3;
            boolean preserveAllSemiColons = level < 2;
            boolean preserveStringLiterals = level < 1;
            out = new FileWriter(compressed);
            compressor.compress((Writer)out, linebreakpos, munge, true, preserveAllSemiColons, preserveStringLiterals);
        }
        catch (Exception e) {
            try {
                throw new CompressionException("Failed to create compressed file", (Throwable)e, input);
            }
            catch (Throwable throwable) {
                IOUtil.close(out);
                throw throwable;
            }
        }
        IOUtil.close((Writer)out);
    }
}

