/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.jpopulator.impl;

import io.github.benas.jpopulator.randomizers.DateRangeRandomizer;
import io.github.benas.jpopulator.randomizers.validation.MaxValueRandomizer;
import io.github.benas.jpopulator.randomizers.validation.MinValueRandomizer;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.math3.random.RandomDataGenerator;

final class BeanValidationRandomizer {
    private BeanValidationRandomizer() {
    }

    public static Object getRandomValue(Field field) {
        Calendar calendar;
        Class<?> fieldType = field.getType();
        Object result = null;
        if (field.isAnnotationPresent(AssertFalse.class)) {
            result = false;
        }
        if (field.isAnnotationPresent(AssertTrue.class)) {
            result = true;
        }
        if (field.isAnnotationPresent(Null.class)) {
            result = null;
        }
        if (field.isAnnotationPresent(Future.class)) {
            calendar = Calendar.getInstance();
            calendar.add(1, 10);
            result = new DateRangeRandomizer(new Date(), calendar.getTime()).getRandomValue();
        }
        if (field.isAnnotationPresent(Past.class)) {
            calendar = Calendar.getInstance();
            calendar.add(1, -10);
            result = new DateRangeRandomizer(calendar.getTime(), new Date()).getRandomValue();
        }
        if (field.isAnnotationPresent(Max.class)) {
            Max maxAnnotation = field.getAnnotation(Max.class);
            long maxValue = maxAnnotation.value();
            result = MaxValueRandomizer.getRandomValue(fieldType, maxValue);
        }
        if (field.isAnnotationPresent(DecimalMax.class)) {
            DecimalMax decimalMaxAnnotation = field.getAnnotation(DecimalMax.class);
            BigDecimal decimalMaxValue = new BigDecimal(decimalMaxAnnotation.value());
            result = MaxValueRandomizer.getRandomValue(fieldType, decimalMaxValue.longValue());
        }
        if (field.isAnnotationPresent(Min.class)) {
            Min minAnnotation = field.getAnnotation(Min.class);
            long minValue = minAnnotation.value();
            result = MinValueRandomizer.getRandomValue(fieldType, minValue);
        }
        if (field.isAnnotationPresent(DecimalMin.class)) {
            DecimalMin decimalMinAnnotation = field.getAnnotation(DecimalMin.class);
            BigDecimal decimalMinValue = new BigDecimal(decimalMinAnnotation.value());
            result = MinValueRandomizer.getRandomValue(fieldType, decimalMinValue.longValue());
        }
        if (field.isAnnotationPresent(Size.class)) {
            Size sizeAnnotation = field.getAnnotation(Size.class);
            int minSize = sizeAnnotation.min();
            int maxSize = sizeAnnotation.max();
            result = RandomStringUtils.randomAlphabetic((int)new RandomDataGenerator().nextInt(minSize, maxSize));
        }
        return result;
    }
}

