/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.jpopulator.randomizers;

import io.github.benas.jpopulator.api.Randomizer;
import io.github.benas.jpopulator.util.ConstantsUtil;
import java.util.HashMap;
import java.util.Map;

public class MapRandomizer<K, V>
implements Randomizer<Map<K, V>> {
    private int minElements;
    private int maxElements;
    private int nbElements;
    private Randomizer<K> keyRandomizer;
    private Randomizer<V> valueRandomizer;

    public MapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer) {
        this(keyRandomizer, valueRandomizer, 0, (byte)Math.abs((byte)ConstantsUtil.RANDOM.nextInt()));
    }

    public MapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer, int nbElements) {
        this(keyRandomizer, valueRandomizer, nbElements, nbElements);
    }

    public MapRandomizer(Randomizer<K> keyRandomizer, Randomizer<V> valueRandomizer, int minElements, int maxElements) {
        this.checkArguments(minElements, maxElements);
        this.minElements = minElements;
        this.maxElements = maxElements + 1;
        this.keyRandomizer = keyRandomizer;
        this.valueRandomizer = valueRandomizer;
        this.nbElements = ConstantsUtil.RANDOM.nextInt(this.maxElements - this.minElements) + this.minElements;
    }

    @Override
    public Map<K, V> getRandomValue() {
        HashMap<K, V> result = new HashMap<K, V>();
        for (int i = 0; i < this.nbElements; ++i) {
            result.put(this.keyRandomizer.getRandomValue(), this.valueRandomizer.getRandomValue());
        }
        return result;
    }

    private void checkArguments(int minElements, int maxElements) {
        if (minElements < 0) {
            throw new IllegalArgumentException("The minimum number of elements to generate must be positive");
        }
        if (minElements < 1) {
            throw new IllegalArgumentException("The maximum number of elements to generate must be greater than or equal to 1");
        }
        if (maxElements < minElements) {
            throw new IllegalArgumentException("The maximum number of elements should be greater than or equal to the minimum number of elements.");
        }
    }
}

