/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.jpopulator.randomizers;

import io.github.benas.jpopulator.api.Randomizer;
import java.util.Random;

public class OptionalRandomizer<T>
implements Randomizer<T> {
    private static final int MAX_PERCENT = 100;
    private final Random randomPercent = new Random(System.currentTimeMillis());
    private Randomizer<T> delegate;
    private int optionalPercent;

    public OptionalRandomizer(Randomizer<T> delegate, int optionalPercent) {
        this.delegate = delegate;
        this.optionalPercent = optionalPercent > 100 ? 100 : (optionalPercent < 0 ? 0 : optionalPercent);
    }

    @Override
    public T getRandomValue() {
        if (this.randomPercent.nextInt(100) + 1 <= this.optionalPercent) {
            return this.delegate.getRandomValue();
        }
        return null;
    }

    public static <T> Randomizer<T> option(Randomizer<T> delegate, int optionalPercent) {
        return new OptionalRandomizer<T>(delegate, optionalPercent);
    }
}

