/*
 * Decompiled with CFR 0.152.
 */
package io.github.hengyunabc.mybatis;

import io.github.hengyunabc.mybatis.CacheFactory;
import io.github.hengyunabc.mybatis.SharedSpringContext;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.springframework.context.ApplicationContext;

public class FacadeCache
implements Cache {
    public static final String DEFAULT_CACHE_FACTORY_BEAN_NAME = "mybatisCacheDefaultFactory";
    Cache cache;
    String springContextName = null;
    String cacheFactoryBeanName = null;

    public FacadeCache(String id) {
        String contextName = this.springContextName != null ? this.springContextName : "springContext";
        ApplicationContext applicationContext = SharedSpringContext.get(contextName);
        if (applicationContext == null) {
            throw new RuntimeException("can not found spring applicationContext, need a SharedSpringContextSetter!!");
        }
        String beanName = this.cacheFactoryBeanName != null ? this.cacheFactoryBeanName : DEFAULT_CACHE_FACTORY_BEAN_NAME;
        CacheFactory cacheFactory = (CacheFactory)applicationContext.getBean(beanName, CacheFactory.class);
        if (cacheFactory == null) {
            throw new RuntimeException("can not found CacheFactory, need a bean name is:" + beanName);
        }
        this.cache = cacheFactory.getCache(id);
    }

    public String getId() {
        return this.cache.getId();
    }

    public void putObject(Object key, Object value) {
        this.cache.putObject(key, value);
    }

    public Object getObject(Object key) {
        return this.cache.getObject(key);
    }

    public Object removeObject(Object key) {
        return this.cache.removeObject(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public int getSize() {
        return this.cache.getSize();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.cache.getReadWriteLock();
    }

    public String getSpringContextName() {
        return this.springContextName;
    }

    public void setSpringContextName(String springContextName) {
        this.springContextName = springContextName;
    }

    public String getCacheFactoryBeanName() {
        return this.cacheFactoryBeanName;
    }

    public void setCacheFactoryBeanName(String cacheFactoryBeanName) {
        this.cacheFactoryBeanName = cacheFactoryBeanName;
    }
}

