/*
 * Decompiled with CFR 0.152.
 */
package io.github.hengyunabc.mybatis;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.ehcache.InstrumentedEhcache;
import io.github.hengyunabc.mybatis.EhcacheCache;
import io.github.hengyunabc.mybatis.MybatisEhcacheFactory;
import javax.annotation.PostConstruct;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.ibatis.cache.Cache;

public class MybatisMetricsEhcacheFactory
extends MybatisEhcacheFactory {
    MetricRegistry registry;
    String sharedMetricRegistryName;

    @PostConstruct
    public void init() {
        if (this.registry == null && this.sharedMetricRegistryName != null) {
            this.registry = SharedMetricRegistries.getOrCreate((String)this.sharedMetricRegistryName);
        }
    }

    @Override
    public Cache getCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        if (!this.cacheManager.cacheExists(id)) {
            CacheConfiguration temp = null;
            temp = this.cacheConfiguration != null ? this.cacheConfiguration.clone() : this.cacheManager.getConfiguration().getDefaultCacheConfiguration().clone();
            temp.setName(id);
            net.sf.ehcache.Cache cache = new net.sf.ehcache.Cache(temp);
            Ehcache instrumentCache = InstrumentedEhcache.instrument((MetricRegistry)this.registry, (Ehcache)cache);
            this.cacheManager.addCache(instrumentCache);
        }
        return new EhcacheCache(id, this.cacheManager.getEhcache(id));
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(MetricRegistry registry) {
        this.registry = registry;
    }

    public String getSharedMetricRegistryName() {
        return this.sharedMetricRegistryName;
    }

    public void setSharedMetricRegistryName(String sharedMetricRegistryName) {
        this.sharedMetricRegistryName = sharedMetricRegistryName;
    }
}

