/*
 * Decompiled with CFR 0.152.
 */
package io.github.hengyunabc.mybatis;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.context.ApplicationContext;

public class SharedSpringContext {
    private static final ConcurrentMap<String, ApplicationContext> CONTEXTs = new ConcurrentHashMap<String, ApplicationContext>();
    public static final String DEFAULT_SPRINGCONTEXT_NAME = "springContext";

    private SharedSpringContext() {
    }

    public static void clear() {
        CONTEXTs.clear();
    }

    public static Set<String> names() {
        return CONTEXTs.keySet();
    }

    public static void removeDefaultContext() {
        SharedSpringContext.remove(DEFAULT_SPRINGCONTEXT_NAME);
    }

    public static void remove(String key) {
        CONTEXTs.remove(key);
    }

    public static ApplicationContext addDefaultContext(ApplicationContext context) {
        return SharedSpringContext.add(DEFAULT_SPRINGCONTEXT_NAME, context);
    }

    public static ApplicationContext add(String name, ApplicationContext context) {
        return CONTEXTs.putIfAbsent(name, context);
    }

    public static ApplicationContext getDefaultContext() {
        return SharedSpringContext.get(DEFAULT_SPRINGCONTEXT_NAME);
    }

    public static ApplicationContext get(String name) {
        return (ApplicationContext)CONTEXTs.get(name);
    }
}

